/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * TableListContentsProvider.java
 *
 * Copyright European Southern Observatory 2008
 */

package alma.obops.tmcdbgui.views.providers;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

import alma.obops.dam.config.TmcdbContextFactory;
import alma.obops.dam.utils.HibernateUtils.TableDefinition;


/**
 * Contents provider for the table list.
 *
 * @author amchavan, Aug 29, 2008
 * 
 */



public class TableListContentsProvider implements IStructuredContentProvider {

    protected String[] tableList;
    
    public void dispose() {
        // no-op
    }

    @SuppressWarnings("unchecked")
	public void inputChanged( Viewer v, Object oldInput, Object newInput ) {

    	if( newInput == null ) {
    		tableList = new String[0];
    		return;
    	}

    	List<TableDefinition> tables = (List<TableDefinition>)newInput;
    	List<String> tableNames = new ArrayList<String>();
    	for(TableDefinition td: tables)
    		if( td.schemaName.compareToIgnoreCase(TmcdbContextFactory.INSTANCE.getConnectionUser()) == 0 )
    			tableNames.add(td.tableName);
        tableList = tableNames.toArray(new String[tableNames.size()]);
    }

    /**
     * @param input  This must be a valid (open) database connection
     * @return The list of all table names in that database
     * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
     */
    public String[] getElements( Object input ) {
        return tableList;
    }
}