/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.views.providers;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;

/**
 * Key listener for tables which wish to allow the user to tab between fields.
 * @author sharring
 */
public class TabKeyListener implements KeyListener 
{
	private CellEditor editor;
	private TableViewer viewer;
	private int column;
	
	public TabKeyListener(CellEditor editor, TableViewer viewer, int column)
	{
		this.editor = editor;
		this.viewer = viewer;
		this.column = column;
	}
	
	@Override
	public void keyPressed(KeyEvent evt)
    {
        if (evt.keyCode == SWT.TAB)
        {
        	int row = viewer.getTable().getSelectionIndex();
        	int col = column;
        	
        	updateSelection(row, col);
        }
    }

    private void updateSelection(int row, int col) 
    {
    	if(col == viewer.getTable().getColumnCount() - 1)
    	{
    		col = 0;
    		row++;
    	}
    	else {
    		col++;
    	}
    	Object element = viewer.getElementAt(row);
    	if(null != element)
    	{
    		viewer.editElement(element, col);
    		if(!viewer.isCellEditorActive())
    		{
    			updateSelection(row, col);
    		}
    	}
    	else {
    		editor.getControl().traverse(SWT.TRAVERSE_TAB_NEXT);
    	}
	}

	@Override
	public void keyReleased(KeyEvent evt){}

}
