/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.views.providers;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

import alma.ReceiverBandMod.ReceiverBand;
import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.tmcdb.domain.Antenna;
import alma.tmcdb.domain.PointingModelCoeff;

/**
 * Utility/helper class for editing of pointing models in a tabular form; an instance 
 * of this class represents a single row in the table, comprising the coefficient 
 * name, coefficient value, plus 10 offsets (one for each band).
 * @author sharring
 */
public class PointingModelRow 
{
	public static final Image CHANGED_IMAGE = RcpUtils.getImage("icons/warning.png");
	public static final Image ADDED_IMAGE = RcpUtils.getImage("icons/added.gif");
	public static final Image DELETED_IMAGE = RcpUtils.getImage("icons/deleted.gif");
	
	private Image coeffNameImage;
	private Image coeffValueImage; 
	private Image offset1Image; 
	private Image offset2Image; 
	private Image offset3Image; 
	private Image offset4Image;
	private Image offset5Image; 
	private Image offset6Image; 
	private Image offset7Image; 
	private Image offset8Image;
	private Image offset9Image;
	private Image offset10Image;
	
	private Font coeffNameFont;
	private Font coeffValueFont; 
	private Font offset1Font; 
	private Font offset2Font; 
	private Font offset3Font; 
	private Font offset4Font;
	private Font offset5Font; 
	private Font offset6Font; 
	private Font offset7Font; 
	private Font offset8Font;
	private Font offset9Font;
	private Font offset10Font;

	private Antenna antenna;
	private PointingModelCoeff coeff;
	private String coeffName;
	
	public PointingModelRow(Antenna antenna, String coeffName, PointingModelCoeff coeff)
	{
		this.antenna = antenna;
		this.coeffName = coeffName;
		this.coeff = coeff;
	}
	
	public Antenna getAntenna() {
		return antenna;
	}

	public PointingModelCoeff getCoeff() 
	{
		return coeff;
	}
	
	public String getCoeffName() {
		return coeffName;
	}
	
	public void setCoeffName(String coeffName) {
		this.coeffName = coeffName;
	}
	
	public Float getCoeffValue() {
		return coeff.getValue();
	}
	
	public void setCoeffValue(Float value) {
		this.coeff.setValue(value);
	}
	
	public Double getOffset1() {
		Double retVal = this.coeff.getOffsets().get(ReceiverBand.ALMA_RB_01);
		if(retVal == null) 
		{
			retVal = new Double(0.0);
		}
		return retVal;
	}
	
	public void setOffset1(Double offset1) {
		this.coeff.getOffsets().put(ReceiverBand.ALMA_RB_01, offset1);
	}
	
	public Double getOffset2() {
		Double retVal = this.coeff.getOffsets().get(ReceiverBand.ALMA_RB_02);
		if(retVal == null) 
		{
			retVal = new Double(0.0);
		}
		return retVal;
	}
	
	public void setOffset2(Double offset2) {
		this.coeff.getOffsets().put(ReceiverBand.ALMA_RB_02, offset2);
	}
	
	public Double getOffset3() {
		Double retVal = this.coeff.getOffsets().get(ReceiverBand.ALMA_RB_03);
		if(retVal == null) 
		{
			retVal = new Double(0.0);
		}
		return retVal;
	}
	
	public void setOffset3(Double offset3) {
		this.coeff.getOffsets().put(ReceiverBand.ALMA_RB_03, offset3);
	}
	
	public Double getOffset4() {
		Double retVal = this.coeff.getOffsets().get(ReceiverBand.ALMA_RB_04);
		if(retVal == null) 
		{
			retVal = new Double(0.0);
		}
		return retVal;
	}
	
	public void setOffset4(Double offset4) {
		this.coeff.getOffsets().put(ReceiverBand.ALMA_RB_04, offset4);
	}
	
	public Double getOffset5() {
		Double retVal = this.coeff.getOffsets().get(ReceiverBand.ALMA_RB_05);
		if(retVal == null) 
		{
			retVal = new Double(0.0);
		}
		return retVal;
	}
	
	public void setOffset5(Double offset5) {
		this.coeff.getOffsets().put(ReceiverBand.ALMA_RB_05, offset5);
	}
	
	public Double getOffset6() {
		Double retVal = this.coeff.getOffsets().get(ReceiverBand.ALMA_RB_06);
		if(retVal == null) 
		{
			retVal = new Double(0.0);
		}
		return retVal;
	}
	
	public void setOffset6(Double offset6) {
		this.coeff.getOffsets().put(ReceiverBand.ALMA_RB_06, offset6);
	}
	
	public Double getOffset7() {
		Double retVal = this.coeff.getOffsets().get(ReceiverBand.ALMA_RB_07);
		if(retVal == null) 
		{
			retVal = new Double(0.0);
		}
		return retVal;
	}
	
	public void setOffset7(Double offset7) {
		this.coeff.getOffsets().put(ReceiverBand.ALMA_RB_07, offset7);
	}
	
	public Double getOffset8() {
		Double retVal = this.coeff.getOffsets().get(ReceiverBand.ALMA_RB_08);
		if(retVal == null) 
		{
			retVal = new Double(0.0);
		}
		return retVal;
	}
	
	public void setOffset8(Double offset8) {
		this.coeff.getOffsets().put(ReceiverBand.ALMA_RB_08, offset8);
	}
	
	public Double getOffset9() {
		Double retVal = this.coeff.getOffsets().get(ReceiverBand.ALMA_RB_09);
		if(retVal == null) 
		{
			retVal = new Double(0.0);
		}
		return retVal;
	}
	
	public void setOffset9(Double offset9) {
		this.coeff.getOffsets().put(ReceiverBand.ALMA_RB_09, offset9);
	}
	
	public Double getOffset10() {
		Double retVal = this.coeff.getOffsets().get(ReceiverBand.ALMA_RB_10);
		if(retVal == null) 
		{
			retVal = new Double(0.0);
		}
		return retVal;
	}
	
	public void setOffset10(Double offset10) {
		this.coeff.getOffsets().put(ReceiverBand.ALMA_RB_10, offset10);
	}
	

	public Image getCoeffNameImage() {
		return coeffNameImage;
	}

	public void setCoeffNameImage(Image coeffNameImage) {
		this.coeffNameImage = coeffNameImage;
	}

	public void setCoeffNameFont(Font coeffNameFont) {
		this.coeffNameFont = coeffNameFont;
	}

	public void setCoeffValueFont(Font coeffValueFont) {
		this.coeffValueFont = coeffValueFont;
	}

	public Image getCoeffValueImage() {
		return coeffValueImage;
	}

	public void setCoeffValueImage(Image coeffValueImage) {
		this.coeffValueImage = coeffValueImage;
	}

	public Image getOffset1Image() {
		return offset1Image;
	}

	public void setOffset1Image(Image offset1Image) {
		this.offset1Image = offset1Image;
	}

	public Image getOffset2Image() {
		return offset2Image;
	}

	public void setOffset2Image(Image offset2Image) {
		this.offset2Image = offset2Image;
	}

	public Image getOffset3Image() {
		return offset3Image;
	}

	public void setOffset3Image(Image offset3Image) {
		this.offset3Image = offset3Image;
	}

	public Image getOffset4Image() {
		return offset4Image;
	}

	public void setOffset4Image(Image offset4Image) {
		this.offset4Image = offset4Image;
	}

	public Image getOffset5Image() {
		return offset5Image;
	}

	public void setOffset5Image(Image offset5Image) {
		this.offset5Image = offset5Image;
	}

	public Image getOffset6Image() {
		return offset6Image;
	}

	public void setOffset6Image(Image offset6Image) {
		this.offset6Image = offset6Image;
	}

	public Image getOffset7Image() {
		return offset7Image;
	}

	public void setOffset7Image(Image offset7Image) {
		this.offset7Image = offset7Image;
	}

	public Image getOffset8Image() {
		return offset8Image;
	}

	public void setOffset8Image(Image offset8Image) {
		this.offset8Image = offset8Image;
	}

	public Image getOffset9Image() {
		return offset9Image;
	}

	public void setOffset9Image(Image offset9Image) {
		this.offset9Image = offset9Image;
	}

	public Image getOffset10Image() {
		return offset10Image;
	}

	public void setOffset10Image(Image offset10Image) {
		this.offset10Image = offset10Image;
	}

	public Font getCoeffNameFont() {
		return this.coeffNameFont;
	}

	public Font getCoeffValueFont() {
		return this.coeffValueFont;
	}

	public Font getOffset1Font() {
		return this.offset1Font;
	}

	public Font getOffset2Font() {
		return this.offset2Font;
	}

	public Font getOffset3Font() {
		return this.offset3Font;
	}

	public Font getOffset4Font() {
		return this.offset4Font;
	}

	public Font getOffset5Font() {
		return this.offset5Font;
	}

	public Font getOffset6Font() {
		return this.offset6Font;
	}

	public Font getOffset7Font() {
		return this.offset7Font;
	}

	public Font getOffset8Font() {
		return this.offset8Font;
	}

	public Font getOffset9Font() {
		return this.offset9Font;
	}

	public Font getOffset10Font() {
		return this.offset10Font;
	}
	
	public void setOffset1Font(Font offset1Font) {
		this.offset1Font = offset1Font;
	}

	public void setOffset2Font(Font offset2Font) {
		this.offset2Font = offset2Font;
	}

	public void setOffset3Font(Font offset3Font) {
		this.offset3Font = offset3Font;
	}

	public void setOffset4Font(Font offset4Font) {
		this.offset4Font = offset4Font;
	}

	public void setOffset5Font(Font offset5Font) {
		this.offset5Font = offset5Font;
	}

	public void setOffset6Font(Font offset6Font) {
		this.offset6Font = offset6Font;
	}

	public void setOffset7Font(Font offset7Font) {
		this.offset7Font = offset7Font;
	}

	public void setOffset8Font(Font offset8Font) {
		this.offset8Font = offset8Font;
	}

	public void setOffset9Font(Font offset9Font) {
		this.offset9Font = offset9Font;
	}

	public void setOffset10Font(Font offset10Font) {
		this.offset10Font = offset10Font;
	}

}
