/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.views.providers;

import java.util.List;

import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.utils.conversation.BaseElementConversationUtils;
import alma.tmcdb.domain.Pad;
import alma.tmcdb.history.HistoryRecord;

public class PadHistoryTableContentsProvider implements IStructuredContentProvider 
{
	private List<HistoryRecord> historyRecords = null;

	@Override
	public void dispose() {
	}

	@Override
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) 
	{
		if(!(newInput instanceof Pad)) {
			return;
		}
		
		Pad pad = (Pad) newInput;
		try {
			historyRecords = BaseElementConversationUtils.getInstance().getPadHistory(pad);
		} catch(Exception e) {
			RcpUtils.errorMessage(e, viewer.getControl().getShell(), "Cannot load view's contents",
					"An unexpected error ocurred when trying to load the pad's history from the TMCDB");
		}
	}

	@Override
	public Object[] getElements(Object inputElement) {
		return historyRecords != null ? historyRecords.toArray() : new HistoryRecord[0];
	}
}
