/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * ConfigurationTreeLabelProvider.java
 *
 * Copyright European Southern Observatory 2008
 */

package alma.obops.tmcdbgui.views.providers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

import alma.acs.tmcdb.EventChannel;
import alma.obops.tmcdbgui.utils.ImageHelper;

/**
 * Provide object name and label for a SW deployment tree
 * 
 * @author rtobar, Feb 19, 2010
 * 
 */


public class NotificationChannelsTableLabelProvider extends LabelProvider implements ITableLabelProvider 
{

    private void failUnsupported(Object element) {
		// Should never happen
        String msg = "Unsupported class: " + element.getClass().getName();
        IllegalArgumentException e = new IllegalArgumentException( msg );
        e.printStackTrace();
        throw e;
	}

	@Override
	public Image getColumnImage(Object element, int columnIndex) {
		if( columnIndex == 0 )
			return ImageHelper.getImage((EventChannel)element);
		return null;
	}

	@Override
	public String getColumnText(Object element, int columnIndex) {

		if( element instanceof EventChannel ) {
			EventChannel e = (EventChannel)element;
			switch( columnIndex ) {
				case 0:
					return e.getName();
				case 1:
					return e.getPath();
			}
		}

		failUnsupported(element);
		return null;
	}   
}