/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * SwDeploymentTreeContentsProvider.java
 *
 * Copyright European Southern Observatory 2008
 */

package alma.obops.tmcdbgui.views.providers;

import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

import alma.acs.tmcdb.EventChannel;
import alma.obops.tmcdbgui.utils.conversation.HwConfigurationConversationUtils;
import alma.obops.tmcdbgui.utils.conversation.SwConfigurationConversationUtils;
import alma.tmcdb.domain.HwConfiguration;

/**
 * Contents provide for a tree of software deployment
 * 
 * @author rtobar, Feb 19, 2010
 * 
 */



public class NotificationChannelsTableContentsProvider implements IStructuredContentProvider 
{

    /**
     * @see org.eclipse.jface.viewers.IContentProvider#dispose()
     */
    public void dispose() {
        // no-op
    }

    /**
     * 
     * 
     * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
     */
    public Object[] getElements( Object element ) 
    {

        if( ! (element instanceof HwConfiguration) ) {
        	failUnsupported(element);
        	return null;
        }

        HwConfiguration currentConfig = (HwConfiguration)element;
        try {
        	currentConfig = HwConfigurationConversationUtils.getInstance().findConfigurationById(currentConfig.getId());
        	SwConfigurationConversationUtils.getInstance().hydrateEventChannels(currentConfig.getSwConfiguration());
        	return currentConfig.getSwConfiguration().getEventChannels().toArray(new EventChannel[0]);
        } catch (Exception e) {
        	e.printStackTrace();
        	// TODO: Proper exception handling?
        }

        return null;
    }

    /**
     * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer,
     *      java.lang.Object, java.lang.Object)
     */
    public void inputChanged( Viewer viewer, Object oldIn, Object newIn ) {
        // no-op
    }
    
	private void failUnsupported(Object element) {
		// Should never happen
        String msg = "Unsupported class: " + element.getClass().getName();
        IllegalArgumentException e = new IllegalArgumentException( msg );
        e.printStackTrace();
        throw e;
	}    
}