/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.views.providers;

import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

/**
 * Label provider for the table used to edit LO Delays for an antenna.
 * @author sharring
 *
 */
public class LoDelayModelLabelProvider extends LabelProvider implements ITableLabelProvider, ITableFontProvider
{

	@Override
	public Image getColumnImage(Object element, int columnIndex) 
	{
		Image retVal = null;
		
		if( !(element instanceof LoDelayModelRow) ) 
		{
			retVal = null;
		}
		else 
		{
			switch(columnIndex) 
			{
			case 0:
				retVal = null;
				break;
			case 1:
				retVal = ((LoDelayModelRow) element).getDelayImage();
				break;
			default: 
				retVal = null;
				break;
			}
		}
		
		return retVal;
	}

	@Override
	public Font getFont(Object element, int columnIndex) 
	{
		Font retVal = null;

		if( !(element instanceof LoDelayModelRow) ) 
		{
			retVal = null;
		}
		else 
		{
			LoDelayModelRow row = (LoDelayModelRow)element;
			switch(columnIndex) 
			{
			case 0:
				retVal = null;
				break;
			case 1:
				retVal = row.getDelayFont();
				break;
			default:
				retVal = null;
				break;
			}
		}
		return retVal;
	}
	
	@Override
	public String getColumnText(Object element, int columnIndex) 
	{
		String retVal = null;

		if( !(element instanceof LoDelayModelRow) ) 
		{
			retVal = null;
		}
		else 
		{
			LoDelayModelRow row = (LoDelayModelRow)element;
			switch(columnIndex) 
			{
			case 0:
				retVal = IfDelayModelLabelProvider.getStringForBaseband(row.getDelay().getBaseband());
				break;
			case 1:
				retVal = String.valueOf(row.getDelay().getDelay());
				break;
			default:
				retVal = null;
				break;
			}
		}
		return retVal;
	}

}
