/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.views.providers;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;

import alma.obops.tmcdbgui.widgets.support.DirtyListener;

/**
 * Editing support for the table used to edit LO delays for an antenna.
 * @author sharring
 */
public class LoDelayModelEditingSupport extends EditingSupport 
{
	private CellEditor _editor;
	private DirtyListener _listener;
	private int _column;
	
	public LoDelayModelEditingSupport(final TableViewer viewer, int column, DirtyListener listener) 
	{
		super(viewer);
		this._listener = listener;
		_column = column;
		_editor = new TextCellEditor(viewer.getTable());
		_editor.getControl().addTraverseListener(new TabTraverseListener());
		_editor.getControl().addKeyListener(new TabKeyListener(_editor, viewer, _column));
		
		switch(column) {
		case 0:
			_editor.setValidator(null);
			break;
		case 1:
			_editor.setValidator(new ScientificNotationCellEditorValidator());
			break;
		}
	}

	@Override
	protected boolean canEdit(Object element) {
		return _column != 0;
	}

	@Override
	protected CellEditor getCellEditor(Object element) {
		return _editor;
	}

	@Override
	protected Object getValue(Object element) 
	{
		LoDelayModelRow row = (LoDelayModelRow)element;
		Object retVal = null;
		
		switch(_column) {
		case 0:
			retVal = "BB" + row.getDelay().getBaseband();
			break;
		case 1:
			retVal = row.getDelay().getDelay().toString();
			break;
		default:
			retVal = null;
			break;
		}
		return retVal;
	}

	@Override
	protected void setValue(Object element, Object value) 
	{
		LoDelayModelRow row = (LoDelayModelRow)element;
		if(value == null) {
			return;
		}
		String newValue = (String)value;
		switch(_column) 
		{
		case 0:
			break;
		case 1:
			if( !(row.getDelay().getDelay().equals(Double.valueOf(newValue))))
			{
				row.getDelay().setDelay(Double.valueOf(newValue));
				_listener.setDirty(true);
				getViewer().refresh(element, true);
			}
			break;
		}
	}
}
