/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.views.providers;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

import alma.BasebandNameMod.BasebandName;
import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.tmcdb.domain.IFDelay;

/**
 * Represents a single row in the table used to edit IF Delays for an antenna.
 * @author sharring
 *
 */
public class IfDelayModelRow 
{
	public static final Image CHANGED_IMAGE = RcpUtils.getImage("icons/warning.png");
	public static final Image ADDED_IMAGE = RcpUtils.getImage("icons/added.gif");
	public static final Image DELETED_IMAGE = RcpUtils.getImage("icons/deleted.gif");
	
	private BasebandName baseband;
	
	private IFDelay usbHighPolXDelay;
	private IFDelay usbHighPolYDelay;

	private IFDelay usbLowPolXDelay;
	private IFDelay usbLowPolYDelay;
	
	private IFDelay lsbHighPolXDelay;
	private IFDelay lsbHighPolYDelay;

	private IFDelay lsbLowPolXDelay;
	private IFDelay lsbLowPolYDelay;
	
	private Image usbHighPolXDelayImage; 
	private Image usbHighPolYDelayImage; 

	private Image usbLowPolXDelayImage; 
	private Image usbLowPolYDelayImage;
	
	private Image lsbHighPolXDelayImage; 
	private Image lsbHighPolYDelayImage; 
	
	private Image lsbLowPolXDelayImage; 
	private Image lsbLowPolYDelayImage;
	
	private Font usbHighPolXDelayFont; 
	private Font usbHighPolYDelayFont; 
	
	private Font usbLowPolXDelayFont; 
	private Font usbLowPolYDelayFont;
	
	private Font lsbHighPolXDelayFont; 
	private Font lsbHighPolYDelayFont; 
	
	private Font lsbLowPolXDelayFont; 
	private Font lsbLowPolYDelayFont;
	
	public Image getUsbHighPolXDelayImage() {
		return usbHighPolXDelayImage;
	}

	public Image getUsbHighPolYDelayImage() {
		return usbHighPolYDelayImage;
	}

	public Image getUsbLowPolXDelayImage() {
		return usbLowPolXDelayImage;
	}

	public Image getUsbLowPolYDelayImage() {
		return usbLowPolYDelayImage;
	}

	public Image getLsbHighPolXDelayImage() {
		return lsbHighPolXDelayImage;
	}

	public Image getLsbHighPolYDelayImage() {
		return lsbHighPolYDelayImage;
	}

	public Image getLsbLowPolXDelayImage() {
		return lsbLowPolXDelayImage;
	}

	public Image getLsbLowPolYDelayImage() {
		return lsbLowPolYDelayImage;
	}

	public Font getUsbHighPolXDelayFont() {
		return usbHighPolXDelayFont;
	}

	public Font getUsbHighPolYDelayFont() {
		return usbHighPolYDelayFont;
	}

	public Font getUsbLowPolXDelayFont() {
		return usbLowPolXDelayFont;
	}

	public Font getUsbLowPolYDelayFont() {
		return usbLowPolYDelayFont;
	}

	public Font getLsbHighPolXDelayFont() {
		return lsbHighPolXDelayFont;
	}

	public Font getLsbHighPolYDelayFont() {
		return lsbHighPolYDelayFont;
	}

	public Font getLsbLowPolXDelayFont() {
		return lsbLowPolXDelayFont;
	}

	public Font getLsbLowPolYDelayFont() {
		return lsbLowPolYDelayFont;
	}
	
	public void setUsbHighPolXDelayImage(Image usbHighPolXDelayImage) {
		this.usbHighPolXDelayImage = usbHighPolXDelayImage;
	}

	public void setUsbHighPolYDelayImage(Image usbHighPolYDelayImage) {
		this.usbHighPolYDelayImage = usbHighPolYDelayImage;
	}

	public void setUsbLowPolXDelayImage(Image usbLowPolXDelayImage) {
		this.usbLowPolXDelayImage = usbLowPolXDelayImage;
	}

	public void setUsbLowPolYDelayImage(Image usbLowPolYDelayImage) {
		this.usbLowPolYDelayImage = usbLowPolYDelayImage;
	}

	public void setLsbHighPolXDelayImage(Image lsbHighPolXDelayImage) {
		this.lsbHighPolXDelayImage = lsbHighPolXDelayImage;
	}

	public void setLsbHighPolYDelayImage(Image lsbHighPolYDelayImage) {
		this.lsbHighPolYDelayImage = lsbHighPolYDelayImage;
	}

	public void setLsbLowPolXDelayImage(Image lsbLowPolXDelayImage) {
		this.lsbLowPolXDelayImage = lsbLowPolXDelayImage;
	}

	public void setLsbLowPolYDelayImage(Image lsbLowPolYDelayImage) {
		this.lsbLowPolYDelayImage = lsbLowPolYDelayImage;
	}

	public void setUsbHighPolXDelayFont(Font usbHighPolXDelayFont) {
		this.usbHighPolXDelayFont = usbHighPolXDelayFont;
	}

	public void setUsbHighPolYDelayFont(Font usbHighPolYDelayFont) {
		this.usbHighPolYDelayFont = usbHighPolYDelayFont;
	}

	public void setUsbLowPolXDelayFont(Font usbLowPolXDelayFont) {
		this.usbLowPolXDelayFont = usbLowPolXDelayFont;
	}

	public void setUsbLowPolYDelayFont(Font usbLowPolYDelayFont) {
		this.usbLowPolYDelayFont = usbLowPolYDelayFont;
	}

	public void setLsbHighPolXDelayFont(Font lsbHighPolXDelayFont) {
		this.lsbHighPolXDelayFont = lsbHighPolXDelayFont;
	}

	public void setLsbHighPolYDelayFont(Font lsbHighPolYDelayFont) {
		this.lsbHighPolYDelayFont = lsbHighPolYDelayFont;
	}

	public void setLsbLowPolXDelayFont(Font lsbLowPolXDelayFont) {
		this.lsbLowPolXDelayFont = lsbLowPolXDelayFont;
	}

	public void setLsbLowPolYDelayFont(Font lsbLowPolYDelayFont) {
		this.lsbLowPolYDelayFont = lsbLowPolYDelayFont;
	}
	
	public IfDelayModelRow(BasebandName baseband)
	{
		this.baseband = baseband;
	}
	
	public BasebandName getBaseband() {
		return baseband;
	}

	public void setBaseband(BasebandName baseband) {
		this.baseband = baseband;
	}
	
	public IFDelay getUsbHighPolXDelay() {
		return usbHighPolXDelay;
	}

	public void setUsbHighPolXDelay(IFDelay delay) {
		this.usbHighPolXDelay = delay;
	}

	public IFDelay getUsbHighPolYDelay() {
		return usbHighPolYDelay;
	}

	public void setUsbHighPolYDelay(IFDelay delay) {
		this.usbHighPolYDelay = delay;
	}

	public IFDelay getUsbLowPolXDelay() {
		return this.usbLowPolXDelay;
	}

	public void setUsbLowPolXDelay(IFDelay delay) {
		this.usbLowPolXDelay = delay;
	}

	public IFDelay getUsbLowPolYDelay() {
		return usbLowPolYDelay;
	}

	public void setUsbLowPolYDelay(IFDelay delay) {
		this.usbLowPolYDelay = delay;
	}

	public IFDelay getLsbHighPolXDelay() {
		return lsbHighPolXDelay;
	}

	public void setLsbHighPolXDelay(IFDelay delay) {
		this.lsbHighPolXDelay = delay;
	}

	public IFDelay getLsbHighPolYDelay() {
		return lsbHighPolYDelay;
	}

	public void setLsbHighPolYDelay(IFDelay delay) {
		this.lsbHighPolYDelay = delay;
	}

	public IFDelay getLsbLowPolXDelay() {
		return lsbLowPolXDelay;
	}

	public void setLsbLowPolXDelay(IFDelay delay) {
		this.lsbLowPolXDelay = delay;
	}

	public IFDelay getLsbLowPolYDelay() {
		return lsbLowPolYDelay;
	}

	public void setLsbLowPolYDelay(IFDelay delay) {
		this.lsbLowPolYDelay = delay;
	}
}
