/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.views.providers;

import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

import alma.BasebandNameMod.BasebandName;

/**
 * Label provider for the table used in editing IF delays for an antenna.
 * @author sharring
 *
 */
public class IfDelayModelLabelProvider extends LabelProvider implements ITableLabelProvider,  ITableFontProvider
{
	@Override
	public Image getColumnImage(Object element, int columnIndex) 
	{
		Image retVal = null;
	
		if( !(element instanceof IfDelayModelRow) ) 
		{
			retVal = null;
		}
		else 
		{
			IfDelayModelRow row = (IfDelayModelRow)element;
			switch(columnIndex) 
			{
			case 0:
				retVal = null;
				break;
			case 1:
				retVal = row.getUsbLowPolXDelayImage();
				break;
			case 2:
				retVal = row.getUsbLowPolYDelayImage();
				break;
			case 3:
				retVal = row.getUsbHighPolXDelayImage();
				break;
			case 4:
				retVal = row.getUsbHighPolYDelayImage();
				break;
			case 5:
				retVal = row.getLsbLowPolXDelayImage();
				break;
			case 6:
				retVal = row.getLsbLowPolYDelayImage();
				break;
			case 7:
				retVal = row.getLsbHighPolXDelayImage();
				break;
			case 8:
				retVal = row.getLsbHighPolYDelayImage();
				break;
			default:
				retVal = null;
				break;
			}
		}

		return retVal;
	}
	
	@Override
	public Font getFont(Object element, int columnIndex) 
	{
		Font retVal = null;
	
		if( !(element instanceof IfDelayModelRow) ) 
		{
			retVal = null;
		}
		else 
		{
			IfDelayModelRow row = (IfDelayModelRow)element;
			switch(columnIndex) 
			{
			case 0:
				retVal = null;
				break;
			case 1:
				retVal = row.getUsbLowPolXDelayFont();
				break;
			case 2:
				retVal = row.getUsbLowPolYDelayFont();
				break;
			case 3:
				retVal = row.getUsbHighPolXDelayFont();
				break;
			case 4:
				retVal = row.getUsbHighPolYDelayFont();
				break;
			case 5:
				retVal = row.getLsbLowPolXDelayFont();
				break;
			case 6:
				retVal = row.getLsbLowPolYDelayFont();
				break;
			case 7:
				retVal = row.getLsbHighPolXDelayFont();
				break;
			case 8:
				retVal = row.getLsbHighPolYDelayFont();
				break;
			default:
				retVal = null;
				break;
			}
		}

		return retVal;
	}

	@Override
	public String getColumnText(Object element, int columnIndex) 
	{
		String retVal = null;
		
		if( !(element instanceof IfDelayModelRow) ) 
		{
			retVal = null;
		}
		else 
		{
			IfDelayModelRow row = (IfDelayModelRow)element;
			switch(columnIndex) 
			{
			case 0:
				retVal = IfDelayModelLabelProvider.getStringForBaseband(row.getBaseband());
				break;
			case 1:
				retVal = String.valueOf(row.getUsbLowPolXDelay().getDelay());
				break;
			case 2:
				retVal = String.valueOf(row.getUsbLowPolYDelay().getDelay());
				break;
			case 3:
				retVal = String.valueOf(row.getUsbHighPolXDelay().getDelay());
				break;
			case 4:
				retVal = String.valueOf(row.getUsbHighPolYDelay().getDelay());
				break;
			case 5:
				retVal = String.valueOf(row.getLsbLowPolXDelay().getDelay());
				break;
			case 6:
				retVal = String.valueOf(row.getLsbLowPolYDelay().getDelay());
				break;
			case 7:
				retVal = String.valueOf(row.getLsbHighPolXDelay().getDelay());
				break;
			case 8:
				retVal = String.valueOf(row.getLsbHighPolYDelay().getDelay());
				break;
			default:
				retVal = null;
			}
		}
		return retVal;
	}

	static String getStringForBaseband(BasebandName baseband) 
	{
		String retVal = null;
		
		if(baseband.equals(BasebandName.BB_1)) 
		{
			retVal = "Baseband 1";
		}
		else if(baseband.equals(BasebandName.BB_2))
		{
			retVal = "Baseband 2";
		}
		else if(baseband.equals(BasebandName.BB_3))
		{
			retVal = "Baseband 3";
		}
		else if(baseband.equals(BasebandName.BB_4))
		{
			retVal = "Baseband 4";
		}
		
		return retVal;
	}
}
