/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.views.providers;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

import alma.tmcdb.history.HistoryRecord;

/**
 * Sorter for history records, used in pm, fm, and potentially other history editors.
 * @author sharring
 */
public class HistoryRecordViewerSorter extends ViewerSorter 
{
	@Override
	public int compare(Viewer viewer, Object obj1, Object obj2) 
	{
		int retVal = super.compare(viewer, obj1, obj2);
		
		if(obj1 instanceof HistoryRecord && obj2 instanceof HistoryRecord)
		{
			HistoryRecord record1 = (HistoryRecord)obj1;
			HistoryRecord record2 = (HistoryRecord)obj2;
			retVal = record1.getVersion().compareTo(record2.getVersion());
		}
		
		return retVal;
	}
}
