/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.views.providers;

import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

/**
 * Label provider for the table used to edit focus models.
 * @author sharring
 */
public class FocusModelLabelProvider extends LabelProvider implements ITableLabelProvider, ITableFontProvider, ITableColorProvider
{
	private static final String ZERO = "0.0";
	
	@Override
	public Image getColumnImage(Object element, int columnIndex) 
	{
		Image retVal = null;
	
		if( !(element instanceof FocusModelRow) ) 
		{
			retVal = null;
		}
		else 
		{
			FocusModelRow row = (FocusModelRow)element;
			switch(columnIndex) 
			{
			case 0:
				retVal = row.getCoeffNameImage();
				break;
			case 1:
				retVal =row.getCoeffValueImage();
				break;
			case 2:
				retVal = row.getOffset1Image();
				break;
			case 3:
				retVal = row.getOffset2Image();
				break;
			case 4:
				retVal = row.getOffset3Image();
				break;
			case 5:
				retVal = row.getOffset4Image();
				break;
			case 6:
				retVal = row.getOffset5Image();
				break;
			case 7:
				retVal = row.getOffset6Image();
				break;
			case 8:
				retVal = row.getOffset7Image();
				break;
			case 9:
				retVal = row.getOffset8Image();
				break;
			case 10:
				retVal = row.getOffset9Image();
				break;
			case 11:
				retVal = row.getOffset10Image();
				break;
			default:
				retVal = null;
			}
		}

		return retVal;
	}

	@Override
	public String getColumnText(Object element, int columnIndex) 
	{
		String retVal = null;
		
		if( !(element instanceof FocusModelRow) ) 
		{
			retVal = null;
		}
		else 
		{
			FocusModelRow row = (FocusModelRow)element;
			switch(columnIndex) 
			{
			case 0:
				retVal = row.getCoeffName();
				break;
			case 1:
				retVal = String.valueOf(row.getCoeffValue());
				break;
			case 2:
				retVal = row.getOffset1() == null ? ZERO : String.valueOf(row.getOffset1());
				break;
			case 3:
				retVal = row.getOffset2() == null ? ZERO : String.valueOf(row.getOffset2());
				break;
			case 4:
				retVal = row.getOffset3() == null ? ZERO : String.valueOf(row.getOffset3());
				break;
			case 5:
				retVal = row.getOffset4() == null ? ZERO : String.valueOf(row.getOffset4());
				break;
			case 6:
				retVal = row.getOffset5() == null ? ZERO : String.valueOf(row.getOffset5());
				break;
			case 7:
				retVal = row.getOffset6() == null ? ZERO : String.valueOf(row.getOffset6());
				break;
			case 8:
				retVal = row.getOffset7() == null ? ZERO : String.valueOf(row.getOffset7());
				break;
			case 9:
				retVal = row.getOffset8() == null ? ZERO : String.valueOf(row.getOffset8());
				break;
			case 10:
				retVal = row.getOffset9() == null ? ZERO : String.valueOf(row.getOffset9());
				break;
			case 11:
				retVal = row.getOffset10() == null ? ZERO : String.valueOf(row.getOffset10());
				break;
			default:
				retVal = null;
			}
		}
		return retVal;
	}
	
	@Override
	public Font getFont(Object element, int columnIndex) 
	{
		Font retVal = null;

		if( !(element instanceof FocusModelRow) ) 
		{
			retVal = null;
		}
		else 
		{
			FocusModelRow row = (FocusModelRow)element;
			switch(columnIndex) 
			{
			case 0:
				retVal = row.getCoeffNameFont();
				break;
			case 1:
				retVal = row.getCoeffValueFont();
				break;
			case 2:
				retVal = row.getOffset1Font();
				break;
			case 3:
				retVal = row.getOffset2Font();
				break;
			case 4:
				retVal = row.getOffset3Font();
				break;
			case 5:
				retVal = row.getOffset4Font();
				break;
			case 6:
				retVal = row.getOffset5Font();
				break;
			case 7:
				retVal = row.getOffset6Font();
				break;
			case 8:
				retVal = row.getOffset7Font();
				break;
			case 9:
				retVal = row.getOffset8Font();
				break;
			case 10:
				retVal = row.getOffset9Font();
				break;
			case 11:
				retVal = row.getOffset10Font();
				break;
			default:
				retVal = null;
			}
		}
		return retVal;
	}

	public String getText(Object element) {
		return getColumnText(element, 0);
	}

	@Override
	public Color getBackground(Object element, int colIndex) {
		return null;
	}

	@Override
	public Color getForeground(Object element, int colIndex) {
		return null;
	}
}
