/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.views.providers;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

import alma.tmcdb.domain.FEDelay;

/**
 * Represents a single row in the front end delays table.
 * @author sharring
 *
 */
public class FeDelayModelRow 
{
	private short band;
	
	private FEDelay usbPolXDelay;
	private FEDelay usbPolYDelay;

	private FEDelay lsbPolXDelay;
	private FEDelay lsbPolYDelay;
	
	private Image usbPolXDelayImage;
	private Image usbPolYDelayImage;

	private Image lsbPolXDelayImage;
	private Image lsbPolYDelayImage;
	
	private Font usbPolXDelayFont;
	private Font usbPolYDelayFont;

	private Font lsbPolXDelayFont;
	private Font lsbPolYDelayFont;
	
	public Image getUsbPolXDelayImage() {
		return usbPolXDelayImage;
	}
	
	public void setUsbPolXDelayImage(Image usbPolXDelayImage) {
		this.usbPolXDelayImage = usbPolXDelayImage;
	}
	
	public Image getUsbPolYDelayImage() {
		return usbPolYDelayImage;
	}

	public void setUsbPolYDelayImage(Image usbPolYDelayImage) {
		this.usbPolYDelayImage = usbPolYDelayImage;
	}

	public Image getLsbPolYDelayImage() {
		return lsbPolYDelayImage;
	}

	public void setLsbPolYDelayImage(Image lsbPolYDelayImage) {
		this.lsbPolYDelayImage = lsbPolYDelayImage;
	}

	public Font getUsbPolXDelayFont() {
		return usbPolXDelayFont;
	}

	public void setUsbPolXDelayFont(Font usbPolXDelayFont) {
		this.usbPolXDelayFont = usbPolXDelayFont;
	}

	public Font getUsbPolYDelayFont() {
		return usbPolYDelayFont;
	}

	public void setUsbPolYDelayFont(Font usbPolYDelayFont) {
		this.usbPolYDelayFont = usbPolYDelayFont;
	}

	public Font getLsbPolXDelayFont() {
		return lsbPolXDelayFont;
	}

	public void setLsbPolXDelayFont(Font lsbPolXDelayFont) {
		this.lsbPolXDelayFont = lsbPolXDelayFont;
	}

	public Font getLsbPolYDelayFont() {
		return lsbPolYDelayFont;
	}

	public void setLsbPolYDelayFont(Font lsbPolYDelayFont) {
		this.lsbPolYDelayFont = lsbPolYDelayFont;
	}

	public Image getLsbPolXDelayImage() {
		return lsbPolXDelayImage;
	}
	
	public void setLsbPolXDelayImage(Image changedImage) {
		this.lsbPolXDelayImage = changedImage;
	}

	public FeDelayModelRow(short band)
	{
		this.band = band;
	}

	public short getBand() {
		return band;
	}

	public void setBand(short band) {
		this.band = band;
	}

	public FEDelay getUsbPolXDelay() {
		return usbPolXDelay;
	}

	public void setUsbPolXDelay(FEDelay usbPolXDelay) {
		this.usbPolXDelay = usbPolXDelay;
	}

	public FEDelay getUsbPolYDelay() {
		return usbPolYDelay;
	}

	public void setUsbPolYDelay(FEDelay usbPolYDelay) {
		this.usbPolYDelay = usbPolYDelay;
	}

	public FEDelay getLsbPolXDelay() {
		return lsbPolXDelay;
	}

	public void setLsbPolXDelay(FEDelay lsbPolXDelay) {
		this.lsbPolXDelay = lsbPolXDelay;
	}

	public FEDelay getLsbPolYDelay() {
		return lsbPolYDelay;
	}

	public void setLsbPolYDelay(FEDelay lsbPolYDelay) {
		this.lsbPolYDelay = lsbPolYDelay;
	}
}
