/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * 
 */
package alma.obops.tmcdbgui.views.providers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

import alma.acs.tmcdb.DefaultCanAddress;
import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.utils.conversation.DefaultCanAddressConversationUtils;
import alma.obops.tmcdbgui.utils.conversation.HwConfigurationConversationUtils;
import alma.tmcdb.domain.HwConfiguration;

/**
 * @author rtobar
 *
 */
public class DefaultCanAddressListContentsProvider implements ITreeContentProvider {

	private Viewer _viewer;
	private Map<String, List<DefaultCanAddress>> groups;

	public void dispose() {

	}

	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		_viewer = viewer;

		if( newInput == null )
			return;

		List<DefaultCanAddress> dcas = null;
		try {
			HwConfiguration currentConfig = (HwConfiguration)newInput;
        	currentConfig = HwConfigurationConversationUtils.getInstance().findConfigurationById(currentConfig.getId());
			dcas = DefaultCanAddressConversationUtils.getInstance().findAll(currentConfig.getSwConfiguration());
		} catch (Exception e) {
			RcpUtils.errorMessage(e, _viewer.getControl().getShell(), "Error while retrieving DefaultCanAddresses",
			"There was an error while trying to retrieve the data from the DefaultCanAddress table, please check the stacktrace");
			e.printStackTrace();
			return;
		}
		
		Collections.sort(dcas, new Comparator<DefaultCanAddress>() {
			public int compare(DefaultCanAddress o1, DefaultCanAddress o2) {
				return o1.getComponent().getPath().compareTo(o2.getComponent().getPath());
			}
		});

		// Let's group them by path!
		groups = new HashMap<String, List<DefaultCanAddress>>();
		for(DefaultCanAddress dca: dcas) {
			String path = dca.getComponent().getPath();
			List<DefaultCanAddress> dcasForGroup = null;

			for(String savedPath: groups.keySet())
				if( path.matches(savedPath + ".*") ) {
					path = savedPath;
					dcasForGroup = groups.get(savedPath);
				}

			if( dcasForGroup == null ) {
				dcasForGroup = new ArrayList<DefaultCanAddress>();
				groups.put(path, dcasForGroup);
			}
			dcasForGroup.add(dca);
		}
	}

	@Override
	public Object[] getElements(Object inputElement) {
		return groups.keySet().toArray();
	}

	@Override
	public Object[] getChildren(Object parentElement) {
		if( parentElement instanceof String )
			return groups.get(parentElement).toArray();
		return groups.keySet().toArray();
	}

	@Override
	public Object getParent(Object element) {
		return null;
	}

	@Override
	public boolean hasChildren(Object element) {
		if( element instanceof String )
			return true;
		return false;
	}

}
