/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.views.providers;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.tmcdb.domain.Coordinate;

public class CoordinateRow 
{
	public static final Image CHANGED_IMAGE = RcpUtils.getImage("icons/warning.png");
	public static final Image ADDED_IMAGE = RcpUtils.getImage("icons/added.gif");
	public static final Image DELETED_IMAGE = RcpUtils.getImage("icons/deleted.gif");
	
	private Image positionXImage, positionYImage, positionZImage;
	private Font positionXFont, positionYFont, positionZFont;
	private Coordinate position;
	
	public Coordinate getPosition() {
		return this.position;
	}
	
	public void setPosition(Coordinate position) {
		this.position = position;
	}
	
	public Image getPositionXImage() {
		return positionXImage;
	}
	
	public void setPositionXImage(Image positionXImage) {
		this.positionXImage = positionXImage;
	}
	
	public Image getPositionYImage() {
		return positionYImage;
	}
	
	public void setPositionYImage(Image positionYImage) {
		this.positionYImage = positionYImage;
	}
	
	public Image getPositionZImage() {
		return positionZImage;
	}
	
	public void setPositionZImage(Image positionZImage) {
		this.positionZImage = positionZImage;
	}
	
	public Font getPositionXFont() {
		return positionXFont;
	}
	
	public void setPositionXFont(Font positionXFont) {
		this.positionXFont = positionXFont;
	}
	
	public Font getPositionYFont() {
		return positionYFont;
	}
	
	public void setPositionYFont(Font positionYFont) {
		this.positionYFont = positionYFont;
	}
	
	public Font getPositionZFont() {
		return positionZFont;
	}
	
	public void setPositionZFont(Font positionZFont) {
		this.positionZFont = positionZFont;
	}
}
