/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.views.providers;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

import alma.obops.tmcdbgui.views.providers.typedlists.AssemblyList;
import alma.obops.tmcdbgui.views.providers.typedlists.BaseElementList;
import alma.tmcdb.domain.Antenna;
import alma.tmcdb.domain.Assembly;
import alma.tmcdb.domain.BaseElement;
import alma.tmcdb.domain.BaseElementType;
import alma.tmcdb.domain.FrontEnd;
import alma.tmcdb.domain.HolographyTower;
import alma.tmcdb.domain.HolographyTowerToPad;
import alma.tmcdb.domain.HwConfiguration;
import alma.tmcdb.domain.Pad;
import alma.tmcdb.domain.PhotonicReference;
import alma.tmcdb.domain.WeatherStationController;

public class ConfigurationTreeSorter extends ViewerSorter 
{
	@Override
	public int compare(Viewer viewer, Object obj1, Object obj2)
	{
		int retVal = 0;
		
		// TODO: should we have the domain objects implement comparable interface?
		//       it would make things simpler...
		if(obj1 instanceof HwConfiguration)
		{
			retVal = compareHwConfigurationTo((HwConfiguration)obj1, obj2);
		}
		else if(obj1 instanceof Antenna)
		{
			retVal = compareAntennaTo((Antenna)obj1, obj2);	
		}
		else if(obj1 instanceof HolographyTowerToPad)
		{
			retVal = compareHolographyTowerToPadTo((HolographyTowerToPad)obj1, obj2);	
		}
		else if(obj1 instanceof Pad)
		{
			retVal = comparePadTo((Pad)obj1, obj2);
		}
		else if(obj1 instanceof FrontEnd)
		{
			retVal = compareFrontendTo((FrontEnd)obj1, obj2);
		}
		else if(obj1 instanceof BaseElement && ((BaseElement)obj1).getType().equals(BaseElementType.AOSTiming))
		{
			retVal = compareMasterClockTo((BaseElement)obj1, obj2);
		}
		else if(obj1 instanceof BaseElement && ((BaseElement)obj1).getType().equals(BaseElementType.CentralLO))
		{
			retVal = compareCentralRackTo((BaseElement)obj1, obj2);
		}
		else if(obj1 instanceof PhotonicReference)
		{
			retVal = comparePhotonicReferenceTo((PhotonicReference)obj1, obj2);
		}
		else if(obj1 instanceof HolographyTower)
		{
			retVal = compareHolographyTowerTo((HolographyTower)obj1, obj2);
		}
		else if(obj1 instanceof WeatherStationController)
		{
			retVal = compareWeatherStationTo((WeatherStationController)obj1, obj2);
		}
		else if(obj1 instanceof Assembly)
		{
			retVal = compareAssemblyTo((Assembly)obj1, obj2);
		}
		else if(obj1 instanceof AssemblyList)
		{
			retVal = compareAssemblyListTo((AssemblyList)obj1, obj2);
		}
		else if(obj1 instanceof BaseElementList)
		{
			retVal = compareBaseElementListTo((BaseElementList)obj1, obj2);	
		}
		
		return retVal;
	}
	
	private int compareHolographyTowerToPadTo(HolographyTowerToPad h2p, Object obj2) 
	{
		int retVal = 0;
		if(obj2 instanceof HolographyTowerToPad) 
		{
			HolographyTowerToPad h2p2 = (HolographyTowerToPad) obj2;
			retVal = h2p.getPad().getName().compareTo(h2p2.getPad().getName());
		}

		return retVal;
	}

	private int compareAssemblyListTo(AssemblyList obj1, Object obj2) 
	{
		int retVal = 0;
		if(obj2 instanceof AssemblyList)
		{
			AssemblyList list2 = (AssemblyList)obj2;
			retVal = obj1.compareTo(list2);
		}
		return retVal;
	}

	private int compareFrontendTo(FrontEnd obj1, Object obj2) 
	{
		int retVal = 0;
		if(obj2 instanceof FrontEnd) {
			FrontEnd fe2 = (FrontEnd) obj2;
			retVal = obj1.getName().compareTo(fe2.getName());
		}

		return retVal;
	}

	private int compareWeatherStationTo(WeatherStationController obj1, Object obj2) 
	{
		int retVal = 0;
		if(obj2 instanceof WeatherStationController) 
		{
			WeatherStationController be2 = (WeatherStationController) obj2;
			retVal = obj1.getName().compareTo(be2.getName());
		}

		return retVal;
	}

	private int compareHolographyTowerTo(HolographyTower obj1, Object obj2) 
	{
		int retVal = 0;
		if(obj2 instanceof HolographyTower) 
		{
			HolographyTower be2 = (HolographyTower) obj2;
			retVal = obj1.getName().compareTo(be2.getName());
		}

		return retVal;
	}

	private int comparePhotonicReferenceTo(PhotonicReference obj1, Object obj2) 	
	{
		int retVal = 0;
		if(obj2 instanceof PhotonicReference) 
		{
			PhotonicReference be2 = (PhotonicReference) obj2;
			retVal = obj1.getName().compareTo(be2.getName());
		}

		return retVal;
	}

	private int compareAssemblyTo(Assembly obj1, Object obj2) 
	{
		int retVal = 0;
		if(obj2 instanceof Assembly) 
		{
			Assembly assem2 = (Assembly) obj2;
			retVal = obj1.getSerialNumber().compareTo(assem2.getSerialNumber());
		}

		return retVal;
	}
	
	private int compareCentralRackTo(BaseElement obj1, Object obj2) 
	{
		int retVal = 0;
		if(obj2 instanceof PhotonicReference) 
		{
			BaseElement be2 = (BaseElement) obj2;
			retVal = obj1.getName().compareTo(be2.getName());
		}

		return retVal;
	}

	private int compareMasterClockTo(@SuppressWarnings("unused") BaseElement obj1, @SuppressWarnings("unused") Object obj2) 
	{
		int retVal = 0;
		return retVal;
	}

	private int comparePadTo(Pad obj1, Object obj2) 
	{
		int retVal = 0;
		if(obj2 instanceof Pad) {
			Pad pad2 = (Pad) obj2;
			retVal = obj1.getName().compareTo(pad2.getName());
		}
		return retVal;
	}

	private int compareAntennaTo(Antenna obj1, Object obj2) 
	{
		int retVal = 0;
		if(obj2 instanceof Antenna)
		{
			Antenna ant2 = (Antenna)obj2;
			retVal = obj1.getName().compareTo(ant2.getName());	
		}
		return retVal;
	}

	private int compareBaseElementListTo(BaseElementList obj1, Object obj2) 
	{
		int retVal = 0;
		if(obj2 instanceof BaseElementList)
		{
			BaseElementList list2 = (BaseElementList)obj2;
			retVal = obj1.compareTo(list2);
		}
		return retVal;
	}

	private int compareHwConfigurationTo(HwConfiguration obj1, Object obj2) 
	{
		int retVal = 0;
		HwConfiguration config1 = obj1;
		if(obj2 instanceof HwConfiguration) {
			HwConfiguration config2 = (HwConfiguration)obj2;
			if(config1.getId().equals(config2.getId())) {
				retVal = 0;
			}
			else {
				retVal = config1.getName().compareTo(config2.getName());
			}
		}
		else {
			retVal = -1;
		}

		return retVal;
	}
}
