/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * ConfigurationTreeContentsProvider.java
 *
 * Copyright European Southern Observatory 2008
 */

package alma.obops.tmcdbgui.views.providers;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

import alma.obops.tmcdb.alarms.ui.tree.helpers.ThreeColumnDomainObjectHelper;
import alma.obops.tmcdb.alarms.ui.tree.helpers.factory.ThreeColumnDomainObjectHelperFactory;
import alma.tmcdb.domain.HwConfiguration;

/**
 * Contents provide for a tree of configurations and their children
 * 
 * @author amchavan, Sep 11, 2008
 * 
 */



public class ConfigurationTreeContentsProvider implements ITreeContentProvider 
{
	protected ThreeColumnDomainObjectHelperFactory helperFactory;
	
	/**
	 * Constructor.
	 * @param helperFactory the factory to use when creating DomainObjectHelper classes.
	 */
	public ConfigurationTreeContentsProvider(ThreeColumnDomainObjectHelperFactory helperFactory)
	{
		this.helperFactory = helperFactory;
	}
	
    /**
     * @see org.eclipse.jface.viewers.IContentProvider#dispose()
     */
    public void dispose() {
        // no-op
    }

    /**
     * @see org.eclipse.jface.viewers.ITreeContentProvider#getChildren(java.lang.Object)
     */
    public Object[] getChildren( Object parent ) 
    {
    	ThreeColumnDomainObjectHelper helper = helperFactory.getHelper(parent);
    	Object[] retVal = helper.getChildren();
    	return retVal;
    }

    /**
     * This method gets called with the tree's initial input, that is, an array
     * of Configurations
     * 
     * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
     */
    public Object[] getElements( Object element ) 
    {
        if( element instanceof HwConfiguration[] )
            return (Object[]) element;

		// Should never happen
        throw new IllegalArgumentException("Unsupported class: " + element.getClass().getName());
    }

    /**
     * @see org.eclipse.jface.viewers.ITreeContentProvider#getParent(java.lang.Object)
     */
    public Object getParent( Object element ) {
        return null;
    }

    /**
     * @see org.eclipse.jface.viewers.ITreeContentProvider#hasChildren(java.lang.Object)
     */
    public boolean hasChildren( Object element ) 
    {
    	ThreeColumnDomainObjectHelper helper = helperFactory.getHelper(element);
    	boolean hasChildren = false;
    	if(null != helper) {
    	   hasChildren = helper.hasChildren();
    	} 
    	
    	return hasChildren;
    }

    /**
     * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer,
     *      java.lang.Object, java.lang.Object)
     */
    public void inputChanged( Viewer viewer, Object oldIn, Object newIn ) {
        // no-op
    }
    
}