/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.views.providers;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;

/**
 * Utility class representing a row in the antennaToPad table / editor.
 * @author sharring
 */
public class AntennaToPadRow
{
	public static final Image CHANGED_IMAGE = RcpUtils.getImage("icons/warning.png");
	public static final Image ADDED_IMAGE = RcpUtils.getImage("icons/added.gif");
	public static final Image DELETED_IMAGE = RcpUtils.getImage("icons/deleted.gif");
			
	private String coeffName;
	private Double coeffValue;
	private Image aw0Image, an0Image;
	private Font an0Font, aw0Font;
	
	public String getCoeffName() {
		return coeffName;
	}
	public void setCoeffName(String coeffName) {
		this.coeffName = coeffName;
	}
	public Double getCoeffValue() {
		return coeffValue;
	}
	public void setCoeffValue(Double coeffValue) {
		this.coeffValue = coeffValue;
	}
	public void setAw0Image(Image aw0Image) {
		this.aw0Image = aw0Image;
	}
	public Image getAw0Image() {
		return aw0Image;
	}
	public void setAn0Image(Image an0Image) {
		this.an0Image = an0Image;
	}
	public Image getAn0Image() {
		return an0Image;
	}
	public void setAn0Font(Font an0Font) {
		this.an0Font = an0Font;
	}
	public Font getAn0Font() {
		return an0Font;
	}
	public void setAw0Font(Font aw0Font) {
		this.aw0Font = aw0Font;
	}
	public Font getAw0Font() {
		return aw0Font;
	}
}