/*******************************************************************************
  * ALMA - Atacama Large Millimeter Array
  * Copyright (c) NRAO - National Radio Astronomy Observatory, 2012
  * (in the framework of the ALMA collaboration).
  * All rights reserved.
  *
  * This library is free software; you can redistribute it and/or
  * modify it under the terms of the GNU Lesser General Public
  * License as published by the Free Software Foundation; either
  * version 2.1 of the License, or (at your option) any later version.
  *
  * This library is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this library; if not, write to the Free Software
  * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 
*******************************************************************************/
package alma.obops.tmcdbgui.views.providers;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

import alma.tmcdb.domain.AntennaToPad;

/**
 * @author sharring
 *
 */
public class AntennaPadAssignmentHistoryViewerSorter extends ViewerSorter 
{
	@Override
	public int compare(Viewer viewer, Object obj1, Object obj2) 
	{
		int retVal = super.compare(viewer, obj1, obj2);
		
		if(obj1 instanceof AntennaToPad && obj2 instanceof AntennaToPad)
		{
			AntennaToPad record1 = (AntennaToPad)obj1;
			AntennaToPad record2 = (AntennaToPad)obj2;
			retVal = record1.getStartTime().compareTo(record2.getStartTime());
		}
		
		return retVal;
	}
}
