/*******************************************************************************
  * ALMA - Atacama Large Millimeter Array
  * Copyright (c) NRAO - National Radio Astronomy Observatory, 2012
  * (in the framework of the ALMA collaboration).
  * All rights reserved.
  *
  * This library is free software; you can redistribute it and/or
  * modify it under the terms of the GNU Lesser General Public
  * License as published by the Free Software Foundation; either
  * version 2.1 of the License, or (at your option) any later version.
  *
  * This library is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this library; if not, write to the Free Software
  * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 
*******************************************************************************/
package alma.obops.tmcdbgui.views.providers;

import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

import alma.obops.tmcdbgui.utils.conversation.BaseElementConversationUtils;
import alma.tmcdb.domain.Antenna;
import alma.tmcdb.domain.AntennaToPad;

/**
 * @author sharring
 *
 */
public class AntennaPadAssignmentHistoryTableContentsProvider implements IStructuredContentProvider 
{
	private Antenna antenna;
	
	@Override
	public void dispose() {
	}

	@Override
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) 
	{
		if(!(newInput instanceof Antenna)) {
			return;
		}
		antenna = (Antenna) newInput;
	}

	@Override
	public  Object[] getElements(Object inputElement) {
		AntennaToPad[] a2ps = null;
		try {
			a2ps = BaseElementConversationUtils.getInstance().findAllAntennaToPadAssignmentsForAntenna(antenna, antenna.getConfiguration().getGlobalConfiguration());
		} catch (Exception e) {
			e.printStackTrace();
			throw new RuntimeException("Could not get antenna to pad assignments", e);
		}
		return a2ps != null ? a2ps : new AntennaToPad[0];

	}
}