/*******************************************************************************
  * ALMA - Atacama Large Millimeter Array
  * Copyright (c) NRAO - National Radio Astronomy Observatory, 2012
  * (in the framework of the ALMA collaboration).
  * All rights reserved.
  *
  * This library is free software; you can redistribute it and/or
  * modify it under the terms of the GNU Lesser General Public
  * License as published by the Free Software Foundation; either
  * version 2.1 of the License, or (at your option) any later version.
  *
  * This library is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this library; if not, write to the Free Software
  * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 
*******************************************************************************/
package alma.obops.tmcdbgui.views.providers;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

import alma.BasebandNameMod.BasebandName;
import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;

/**
 * @author sharring
 *
 */
public class AcaCorrDelaysRow 
{
	public static final Image CHANGED_IMAGE = RcpUtils.getImage("icons/warning.png");
	public static final Image ADDED_IMAGE = RcpUtils.getImage("icons/added.gif");
	public static final Image DELETED_IMAGE = RcpUtils.getImage("icons/deleted.gif");
			
	private BasebandName baseband;
	private Double delay;
	private Image image;
	private Font font;
	
	public BasebandName getBaseband() {
		return baseband;
	}
	public void setBaseband(BasebandName baseband) {
		this.baseband = baseband;
	}
	public Double getDelay() {
		return delay;
	}
	public void setDelay(Double delay) {
		this.delay = delay;
	}
	public Image getImage() {
		return image;
	}
	public void setImage(Image image) {
		this.image = image;
	}
	public Font getFont() {
		return font;
	}
	public void setFont(Font font) {
		this.font = font;
	}
	
}
