/*******************************************************************************
  * ALMA - Atacama Large Millimeter Array
  * Copyright (c) NRAO - National Radio Astronomy Observatory, 2012
  * (in the framework of the ALMA collaboration).
  * All rights reserved.
  *
  * This library is free software; you can redistribute it and/or
  * modify it under the terms of the GNU Lesser General Public
  * License as published by the Free Software Foundation; either
  * version 2.1 of the License, or (at your option) any later version.
  *
  * This library is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this library; if not, write to the Free Software
  * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 
*******************************************************************************/
package alma.obops.tmcdbgui.views.providers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

/**
 * @author sharring
 *
 */
public class AcaCorrDelaysLabelProvider extends LabelProvider implements ITableLabelProvider 
{
	@Override
	public Image getColumnImage(Object element, int columnIndex) {
		return null;
	}

	@Override
	public String getColumnText(Object element, int columnIndex) 
	{
		String retVal = null;
		
		if( !(element instanceof AcaCorrDelaysRow) ) 
		{
			retVal = null;
		}
		else 
		{
			AcaCorrDelaysRow row = (AcaCorrDelaysRow)element;
			switch(columnIndex) 
			{
			case 0:
				retVal = row.getBaseband().toString();
				break;
			case 1:
				retVal = String.valueOf(row.getDelay());
				break;
			default:
				retVal = null;
			}
		}
		return retVal;
	}

	public String getText(Object element) {
		return getColumnText(element, 0);
	}
}
