/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.views.providers;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.tmcdb.history.HistoryRecord;

public abstract class AbstractHistoryTableLabelProvider extends LabelProvider implements ITableLabelProvider 
{
	public abstract String getImageString();

	@Override
	public Image getColumnImage(Object element, int columnIndex) 
	{
		if( columnIndex == 0 && element instanceof HistoryRecord )
			return RcpUtils.getImage(getImageString());
		return null;
	}

	@Override
	public String getColumnText(Object element, int columnIndex) 
	{
		if( !(element instanceof HistoryRecord) )
			return null;

		HistoryRecord record = (HistoryRecord)element;
		switch(columnIndex) 
		{
			case 0:
				return record.getVersion().toString();
			case 1:
				return record.getDescription();
			case 2:
				return record.getModifier();
			case 3:
				// format the date into something meaningful to the user
				DateFormat dfm = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
				dfm.setTimeZone(TimeZone.getTimeZone("UTC"));

				String dateString = null;
				if(null != record.getTimestamp()) {
					long millisecondsSinceEpoch = record.getTimestamp().getTime();
					dateString = dfm.format(millisecondsSinceEpoch);
				}
				return dateString;
			default:
				return null;
		}
	}

	public String getText(Object element) {
		return getColumnText(element, 0);
	}
}

