/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.views.dnd;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;

import alma.acs.tmcdb.AcsService;
import alma.acs.tmcdb.Component;
import alma.acs.tmcdb.Computer;
import alma.acs.tmcdb.Container;

public class SwDeploymentDragListener implements DragSourceListener {

	private StructuredViewer v;

	public SwDeploymentDragListener(TreeViewer v) {
		this.v = v;
	}

	@Override
	public void dragFinished(DragSourceEvent event) {  }

	@SuppressWarnings("unchecked")
	@Override
	public void dragSetData(DragSourceEvent event) {

		IStructuredSelection selection = (IStructuredSelection)v.getSelection();

		if( validateSelecion(selection) ) {
			if( TmcdbObjectTransfer.getInstance().isSupportedType(event.dataType) ) {
				if( selection.getFirstElement() instanceof Container )
					event.data = selection.toList().toArray(new Container[0]);
				else if( selection.getFirstElement() instanceof AcsService )
					event.data = selection.toList().toArray(new AcsService[0]);
				else if( selection.getFirstElement() instanceof Component )
					event.data = selection.toList().toArray(new Component[0]);
				else if( selection.getFirstElement() instanceof Computer )
					event.data = selection.toList().toArray(new Computer[0]);
			}
		}
	}

	@Override
	public void dragStart(DragSourceEvent event) {

		IStructuredSelection selection = (IStructuredSelection)v.getSelection();
		event.doit = false;
		if( validateSelecion(selection) )
			event.doit = true;
	}

	private boolean validateSelecion(IStructuredSelection selection) {
		
		// All selected objects must be of the same kind
		if( selection.getFirstElement() instanceof Container ) {
			for(Object o: selection.toList())
				if( !(o instanceof Container) )
					return false;
		}
		else if( selection.getFirstElement() instanceof AcsService ) {
			for(Object o: selection.toList())
				if( !(o instanceof AcsService) )
					return false;
		}
		else if( selection.getFirstElement() instanceof Component ) {
			for(Object o: selection.toList())
				if( !(o instanceof Component) )
					return false;
		}
		else if( selection.getFirstElement() instanceof Computer ) {
			for(Object o: selection.toList())
				if( !(o instanceof Computer) )
					return false;
		}
		else
			return true;

		return true;
	}
}

