/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.views.dnd;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.TransferData;

import alma.tmcdb.domain.HwConfiguration;

public class NotificationChannelsTableDropAdapter extends ViewerDropAdapter {

	private Viewer v;

	public NotificationChannelsTableDropAdapter(Viewer viewer) {
		super(viewer);
		v = viewer;
	}

	@Override
	public boolean performDrop(Object data) {

		if( data == null )
			return false;

		if( TmcdbObjectTransfer.getInstance().isSupportedType(getCurrentEvent().currentDataType) ) {
			// We only accept HwConfigurations
			if( data instanceof HwConfiguration ) {
				v.setInput(data);
				v.refresh();
				return true;
			}
			return false;
		}
		return false;
	}

	@Override
	public boolean validateDrop(Object target, int operation,
			TransferData transferType) {
		return true;
	}
	
}
