/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.views.dnd;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;

import alma.obops.tmcdbgui.utils.GuiUtils;
import alma.tmcdb.domain.Antenna;
import alma.tmcdb.domain.BaseElement;
import alma.tmcdb.domain.BaseElementType;
import alma.tmcdb.domain.FrontEnd;
import alma.tmcdb.domain.HwConfiguration;
import alma.tmcdb.domain.Pad;
import alma.tmcdb.domain.WeatherStationController;

public class ConfigurationsDragListener implements DragSourceListener {

	private TreeViewer v;

	public ConfigurationsDragListener(TreeViewer v) {
		this.v = v;
	}

	@Override
	public void dragFinished(DragSourceEvent event) { }

	@Override
	public void dragSetData(DragSourceEvent event) {
		IStructuredSelection selection = (IStructuredSelection)v.getSelection();
		if( validateSelecion(selection) ) {
			if( TmcdbObjectTransfer.getInstance().isSupportedType(event.dataType) ) {
				event.data = selection.getFirstElement();
			}
		}
	}

	@Override
	public void dragStart(DragSourceEvent event) {

		IStructuredSelection selection = (IStructuredSelection)v.getSelection();
		event.doit = false;
		if( validateSelecion(selection) )
			event.doit = true;
	}

	private boolean validateSelecion(IStructuredSelection selection) {
		if(!GuiUtils.isGodUser() && !(selection.getFirstElement() instanceof Pad))
		{
			return false;
		}
		
		boolean retVal = false;
		
		if( selection.size() != 1 ) {
			retVal = false;
		}
		else if( selection.getFirstElement() instanceof HwConfiguration ) {
			retVal =  true;
		}
		else if( selection.getFirstElement() instanceof Antenna ) {
			retVal =  true;
		}
		else if( selection.getFirstElement() instanceof FrontEnd ) {
			retVal =  true;
		}
		else if( selection.getFirstElement() instanceof Pad ) {
			retVal =  true;
		}
		else if( selection.getFirstElement() instanceof WeatherStationController ) {
			retVal =  true;
		}
		else if( (selection.getFirstElement() instanceof BaseElement &&  
				((BaseElement)selection.getFirstElement()).getType().equals(BaseElementType.AOSTiming)) ) {
			retVal =  true;
		}
		else if((selection.getFirstElement() instanceof BaseElement &&  
				((BaseElement)selection.getFirstElement()).getType().equals(BaseElementType.CentralLO)) ) {
			retVal =  true;
		}
		else if((selection.getFirstElement() instanceof BaseElement && 
				((BaseElement)selection.getFirstElement()).getType().equals(BaseElementType.PhotonicReference)) ) {
			retVal =  true;
		}
		else if((selection.getFirstElement() instanceof BaseElement && 
				((BaseElement)selection.getFirstElement()).getType().equals(BaseElementType.PhotonicReference)) ) {
			retVal =  true;
		}
		
		return retVal;

	}
}
