/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * RawDataView.java
 *
 * Copyright European Southern Observatory 2008
 */

package alma.obops.tmcdbgui.views;

import java.util.List;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.part.ViewPart;

import alma.obops.dam.ServiceException;
import alma.obops.dam.config.TmcdbContextFactory;
import alma.obops.dam.utils.HibernateUtils.TableDefinition;
import alma.obops.tmcdbgui.handlers.ShowDataAction;
import alma.obops.tmcdbgui.views.providers.TableListContentsProvider;
import alma.obops.tmcdbgui.views.providers.TableListTableLabelProvider;

/**
 * This view lists all database tables
 * 
 * @author amchavan, Sep 3, 2008
 * 
 */



public class TableListView extends ViewPart {

    public static final String ID = "tables.view";
    protected TableViewer tableViewer;
    
    /**
     * @see org.eclipse.ui.part.WorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
     */
    @Override
    public void createPartControl( Composite parent ) {

        int style = SWT.BORDER | SWT.FULL_SELECTION ;

        tableViewer = new TableViewer( parent, style );
        tableViewer.setContentProvider( new TableListContentsProvider());
        tableViewer.setLabelProvider( new TableListTableLabelProvider() );
        tableViewer.setSorter(new ViewerSorter());
        
        Table table = tableViewer.getTable();
        table.setHeaderVisible( true );
        table.setLinesVisible( true );

        tableViewer.addDoubleClickListener(new IDoubleClickListener() {
			public void doubleClick(DoubleClickEvent event) {
				if( event.getSelection() instanceof IStructuredSelection ) {
					String tableName = ((IStructuredSelection)event.getSelection()).getFirstElement().toString();
					IAction showDataAction = new ShowDataAction(tableName);
					showDataAction.run();
				}
			}
        });

        try {
        	List<TableDefinition> tables = TmcdbContextFactory.INSTANCE.getHibernateUtils().getTables(null);
        	tableViewer.setInput(tables);
		} catch (ServiceException e) {
		}

    }

    /**
     * @see org.eclipse.ui.part.WorkbenchPart#setFocus()
     */
    @Override
    public void setFocus() {
        // no-op
    }
    
    /**
     * Display the input list of table names (Strings) in this view.
     */
    public void setInput( Object[] tableList ) {
        tableViewer.setInput( tableList );
    }
}
