/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * RawDataView.java
 *
 * Copyright European Southern Observatory 2008
 */

package alma.obops.tmcdbgui.views;

import java.lang.reflect.InvocationTargetException;
import java.util.List;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

import alma.obops.dam.config.TmcdbContextFactory;
import alma.obops.tmcdbgui.TmcdbGui;
import alma.obops.tmcdbgui.rsviewer.ResultSetViewer;
import alma.obops.tmcdbgui.utils.EclipseProgressMonitor;
import alma.obops.utils.Holder;

/**
 * This view contains the result set viewer to edit the database in expert mode.
 * It can be loaded with the contents of a single table.
 * 
 * @author amchavan, Sep 3, 2008
 * 
 */



public class RawDataView extends ViewPart {

    public static final String ID = "raw-data.view";
    
    protected ResultSetViewer viewer;
    private String currentTable;
    
    /**
     * @see org.eclipse.ui.part.WorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
     */
    public void createPartControl( Composite parent ) {
        int style = SWT.BORDER | SWT.MULTI | SWT.FULL_SELECTION;
        viewer = new ResultSetViewer( parent, style );
    }

    /**
     * @see org.eclipse.ui.part.WorkbenchPart#setFocus()
     */
    public void setFocus() {
        // no-op
    }

    /**
     * Load the view with the complete contents of the last selected table.
     */
    public void reload() {
    	reloadFromTable( this.currentTable );
    }

    /**
     * Load the view with the complete contents of the input table
     * using a <code>SELECT * FROM...</code> statement
     */
    public void reloadFromTable( String table ) {

    	if( table == null )
    		throw new NullPointerException("Table name is null");

    	currentTable = table;

    	final Holder<List<List<Object>>> dataHolder = new Holder<List<List<Object>>>();
    	ProgressMonitorDialog pd = new ProgressMonitorDialog(viewer.getControl().getShell());
		try {
			pd.run(true, false, new IRunnableWithProgress() {
				public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
			    	String sql = "select * from " + currentTable;
			    	EclipseProgressMonitor eMonitor = new EclipseProgressMonitor(monitor);
					dataHolder.field = TmcdbContextFactory.INSTANCE.getHibernateUtils().getData(sql, eMonitor);
				}
			});
		} catch (InvocationTargetException e) {
			e.printStackTrace();
			return;
		} catch (InterruptedException e) {
			e.printStackTrace();
			TmcdbGui.getLogger().warning("Data might be incomplete");
			// Don't return, work with what we have so far
		}

//    	ResultSetUpdater rsu = new ResultSetUpdater( table, hibernateUtils, data );
//    	TmcdbGui.setResultSetUpdater( rsu );
    	viewer.setData( table, dataHolder.field, null );
    }

}