/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * NotificationChannelsView.java
 *
 * Copyright European Southern Observatory 2010
 */

package alma.obops.tmcdbgui.views;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.part.ViewPart;

import alma.obops.tmcdbgui.views.dnd.NotificationChannelsTableDropAdapter;
import alma.obops.tmcdbgui.views.dnd.TmcdbObjectTransfer;
import alma.obops.tmcdbgui.views.providers.NotificationChannelsTableContentsProvider;
import alma.obops.tmcdbgui.views.providers.NotificationChannelsTableLabelProvider;

/**
 * This view contains all the notification channels of a given HW Configuration.
 * It supports dropping of HwConfiguration objects into it, which will produce
 * a full refresh over the table with the details of the notification channels
 * 
 * @author rtobar, Feb 24, 2010
 * 
 */



public class NotificationChannelsView extends ViewPart {

    public static final String ID = "notification-channels.view";
    private TableViewer ncViewer;

    public void createPartControl( Composite parent ) {

    	ncViewer = new TableViewer(parent, SWT.BORDER | SWT.FULL_SELECTION | SWT.MULTI);

    	// Setup the columns
    	String [] titles = { "Name", "Path" };
    	for(int i = 0; i != titles.length; i++) {
    		TableViewerColumn col = new TableViewerColumn(ncViewer, SWT.NONE);
    		col.getColumn().setText(titles[i]);
    		col.getColumn().setMoveable(false);
    		col.getColumn().setResizable(true);
    		col.getColumn().setWidth(250);
    	}
    	Table table = ncViewer.getTable();
    	table.setHeaderVisible(true);
    	table.setLinesVisible(true);

    	ncViewer.setContentProvider( new NotificationChannelsTableContentsProvider() );
    	ncViewer.setLabelProvider( new NotificationChannelsTableLabelProvider() );

    	// Setup the drop support
    	Transfer []types = { TmcdbObjectTransfer.getInstance() };
    	ncViewer.addDropSupport(DND.DROP_MOVE, types, new NotificationChannelsTableDropAdapter(ncViewer));

    }

	@Override
	public void setFocus() {
		ncViewer.getControl().setFocus();
	}

	public TableViewer getNCViewer() {
		return ncViewer;
	}
}
