/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.views;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.part.ViewPart;

import alma.obops.tmcdbgui.views.providers.DeviceLibrariesEditingSupport;
import alma.obops.tmcdbgui.views.providers.DeviceLibrariesTableContentsProvider;
import alma.obops.tmcdbgui.views.providers.DeviceLibrariesTableLabelProvider;

/**
 * This view contains all assembly types present on the DB, together with their
 * information about the "Production Code" and "Simulation Code" that is used
 * by the Startup view to set the Code field of the component that is supposed
 * to be started when an assebly role is set as active.
 * 
 * @author rtobar, Feb 24, 2010
 * 
 */


public class DeviceLibrariesView extends ViewPart {

    public static final String ID = "device-libraries.view";
    private TableViewer librariesViewer;

    public void createPartControl( Composite parent ) {

    	librariesViewer = new TableViewer(parent, SWT.BORDER | SWT.FULL_SELECTION | SWT.MULTI);

    	// Setup the columns
    	String [] titles = { "Assembly Type", "Production Code", "Simulation Code" };
    	for(int i = 0; i != titles.length; i++) {
    		TableViewerColumn col = new TableViewerColumn(librariesViewer, SWT.NONE);
    		col.getColumn().setText(titles[i]);
    		col.getColumn().setMoveable(false);
    		col.getColumn().setResizable(true);
    		col.getColumn().setWidth(250);
    		col.setEditingSupport(new DeviceLibrariesEditingSupport(librariesViewer, i));
    	}
    	Table table = librariesViewer.getTable();
    	table.setHeaderVisible(true);
    	table.setLinesVisible(true);

    	librariesViewer.setSorter(new ViewerSorter());
    	librariesViewer.setContentProvider( new DeviceLibrariesTableContentsProvider() );
    	librariesViewer.setLabelProvider( new DeviceLibrariesTableLabelProvider() );

    	librariesViewer.setInput(new Object()); // trigger a content reload, doesn't need a specific input as it is global data
    }

	@Override
	public void setFocus() {
		librariesViewer.getControl().setFocus();
	}

}
