/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
\ * DefaultCanAddressView.java
 *
 * Copyright European Southern Observatory 2010
 */

package alma.obops.tmcdbgui.views;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

import alma.acs.tmcdb.DefaultCanAddress;
import alma.obops.tmcdbgui.handlers.EditDefaultCanAddressAction;
import alma.obops.tmcdbgui.views.dnd.NotificationChannelsTableDropAdapter;
import alma.obops.tmcdbgui.views.dnd.TmcdbObjectTransfer;
import alma.obops.tmcdbgui.views.providers.DefaultCanAddressListContentsProvider;
import alma.obops.tmcdbgui.views.providers.DefaultCanAddressListLabelProvider;

/**
 * This view contains all the DefaultCanAddress objects for a HW Configuration.
 * It supports dropping of HwConfiguration objects into it, which will produce
 * a full refresh over the list
 * 
 * @author rtobar, Jul 29, 2010
 * 
 */



public class DefaultCanAddressView extends ViewPart {

    public static final String ID = "default-can-addresses.view";
    private TreeViewer dcaViewer;

    private IAction editDCA;

    public void createPartControl( Composite parent ) {

    	dcaViewer = new TreeViewer(parent, SWT.BORDER | SWT.FULL_SELECTION | SWT.MULTI);

    	IBaseLabelProvider lp = new MyDecoratingStyledCellLabelProvider(new DefaultCanAddressListLabelProvider(), getSite().getWorkbenchWindow().getWorkbench().getDecoratorManager(), null);
    	dcaViewer.setSorter( new ViewerSorter() );
    	dcaViewer.setContentProvider( new DefaultCanAddressListContentsProvider() );
    	dcaViewer.setLabelProvider( lp );

    	// Setup the drop support
    	Transfer []types = { TmcdbObjectTransfer.getInstance() };
    	dcaViewer.addDropSupport(DND.DROP_MOVE, types, new NotificationChannelsTableDropAdapter(dcaViewer));

    	// Double-click support for opening the editor
    	editDCA = new EditDefaultCanAddressAction( getSite().getWorkbenchWindow() );
    	dcaViewer.addDoubleClickListener(new IDoubleClickListener() {
			public void doubleClick(DoubleClickEvent event) {
				if( event.getSelection() instanceof IStructuredSelection ) {
					IStructuredSelection selection = (IStructuredSelection)event.getSelection();
					if( selection.getFirstElement() instanceof DefaultCanAddress ) {
						((EditDefaultCanAddressAction)editDCA).selectionChanged(DefaultCanAddressView.this, selection);
						editDCA.run();
					}
				}
			}
		});
    }

	@Override
	public void setFocus() {
		dcaViewer.getControl().setFocus();
	}

	public TreeViewer getDCAViewer() {
		return dcaViewer;
	}
	
	/**
	 * Private class used to allow the ViewerSorter to properly sort the strings; ViewerSorter requires that 
	 * items it is comparing implement the ILableProvider interface (in order to call getText method). Surprisingly,
	 * and counterintuitively, the DecoratingStyledCellLabelProvider doesn't actually implement this interface; so 
	 * we will subclass to make it do so, in order to avoid writing a custom sorter.
	 * 
	 * NOTE: This is a fix for COMP-6649 regarding sorting.
	 * 
	 * @author sharring
	 */
	private static class MyDecoratingStyledCellLabelProvider extends DecoratingStyledCellLabelProvider implements ILabelProvider
	{

		/**
		 * @param labelProvider
		 * @param decorator
		 * @param decorationContext
		 */
		public MyDecoratingStyledCellLabelProvider(
				IStyledLabelProvider labelProvider, ILabelDecorator decorator,
				IDecorationContext decorationContext) 
		{
			super(labelProvider, decorator, decorationContext);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.ILabelProvider#getText(java.lang.Object)
		 */
		@Override
		public String getText(Object element) {
			return this.getStyledText(element).getString();
		}
	}
}
