/*******************************************************************************
  * ALMA - Atacama Large Millimeter Array
  * Copyright (c) NRAO - National Radio Astronomy Observatory, 2012
  * (in the framework of the ALMA collaboration).
  * All rights reserved.
  *
  * This library is free software; you can redistribute it and/or
  * modify it under the terms of the GNU Lesser General Public
  * License as published by the Free Software Foundation; either
  * version 2.1 of the License, or (at your option) any later version.
  *
  * This library is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this library; if not, write to the Free Software
  * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 
*******************************************************************************/
package alma.obops.tmcdbgui.utils.conversation;

import java.lang.reflect.Method;

import alma.acs.tmcdb.NotificationServiceMapping;
import alma.obops.dam.config.TmcdbContextFactory;
import alma.obops.dam.tmcdb.service.NotificationServiceMappingService;
import alma.obops.dam.utils.ConversationInterceptor;
import alma.obops.dam.utils.ConversationTokenProvider;
import alma.obops.dam.utils.ConversationTokenProviderAdapter;
import alma.obops.dam.utils.ConversationTokenProvider.ConversationToken;

/**
 * @author sharring
 *
 */
public class NotificationServiceMappingConversationUtils 
{
	private static NotificationServiceMappingConversationUtils singletonInstance;
	
	private NotificationServiceMappingConversationUtils() 
	{
	}
	
	public static synchronized NotificationServiceMappingConversationUtils getInstance()
	{
		if(null == singletonInstance)
		{
			singletonInstance = new NotificationServiceMappingConversationUtils();
		}
		
		return singletonInstance;
	}
	
	public void saveOrUpdateNotificationServiceMapping(NotificationServiceMapping notificationServiceMapping)  throws Exception 
	{
		Method methodToInvoke = NotificationServiceMappingConversationUtils.class.getMethod("privateSaveOrUpdateNotificationServiceMapping", NotificationServiceMapping.class);	
		ConversationInterceptor conversationInterceptor = TmcdbContextFactory.INSTANCE.getConversationInterceptor();
		Object[] args = new Object[1];
		args[0] = notificationServiceMapping;
		conversationInterceptor.invoke(methodToInvoke, this, args);
	}

	public ConversationTokenProvider privateSaveOrUpdateNotificationServiceMapping(NotificationServiceMapping notificationServiceMapping) {
		ConversationTokenProvider retVal = new ConversationTokenProviderAdapter(ConversationToken.CONVERSATION_COMPLETED);
		NotificationServiceMappingService service = TmcdbContextFactory.INSTANCE.getNotificationServiceMappingService();
		service.update(notificationServiceMapping);
		return retVal;
	}
}
