/*******************************************************************************
  * ALMA - Atacama Large Millimeter Array
  * Copyright (c) NRAO - National Radio Astronomy Observatory, 2012
  * (in the framework of the ALMA collaboration).
  * All rights reserved.
  *
  * This library is free software; you can redistribute it and/or
  * modify it under the terms of the GNU Lesser General Public
  * License as published by the Free Software Foundation; either
  * version 2.1 of the License, or (at your option) any later version.
  *
  * This library is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this library; if not, write to the Free Software
  * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 
*******************************************************************************/
package alma.obops.tmcdbgui.utils.conversation;

import java.lang.reflect.Method;

import alma.obops.dam.config.TmcdbContextFactory;
import alma.obops.dam.tmcdb.service.HolographyTowerToPadService;
import alma.obops.dam.utils.ConversationInterceptor;
import alma.obops.dam.utils.ConversationTokenProvider;
import alma.obops.dam.utils.ConversationTokenProviderAdapter;
import alma.obops.dam.utils.ConversationTokenProvider.ConversationToken;
import alma.tmcdb.domain.HolographyTowerToPad;

/**
 * @author sharring
 *
 */
public class HolographyTowerToPadConversationUtils 
{
	private static HolographyTowerToPadConversationUtils singletonInstance;

	private HolographyTowerToPadConversationUtils() 
	{
	}

	public static synchronized HolographyTowerToPadConversationUtils getInstance()
	{
		if(null == singletonInstance)
		{
			singletonInstance = new HolographyTowerToPadConversationUtils();
		}

		return singletonInstance;
	}	
	
	public ConversationTokenProvider privateDeleteHolographyTowerToPad(HolographyTowerToPad h2p, ConversationToken token)
	{
		ConversationTokenProvider retVal = new ConversationTokenProviderAdapter(token);
		HolographyTowerToPadService h2pService = TmcdbContextFactory.INSTANCE.getHolographyTowerToPadService();
		h2pService.delete(h2p);
		return retVal;
	}
	
	public void saveOrUpdateHolographyTowerToPad(HolographyTowerToPad h2p) throws Exception 
	{
		Method methodToInvoke = HolographyTowerToPadConversationUtils.class.getMethod("privateSaveOrUpdateHolographyTowerToPad", HolographyTowerToPad.class);	
		ConversationInterceptor conversationInterceptor = TmcdbContextFactory.INSTANCE.getConversationInterceptor();
		Object[] args = new Object[1];
		args[0] = h2p;
		conversationInterceptor.invoke(methodToInvoke, this, args);
	}

	public ConversationTokenProvider privateSaveOrUpdateHolographyTowerToPad(HolographyTowerToPad h2p) 
	{
		ConversationTokenProvider retVal = new ConversationTokenProviderAdapter(ConversationToken.CONVERSATION_COMPLETED);
		HolographyTowerToPadService service = TmcdbContextFactory.INSTANCE.getHolographyTowerToPadService();
		service.update(h2p);
		return retVal;
	}

	public void hydrateHolographyTowerToPad(HolographyTowerToPad a2p) throws Exception
	{
		Method methodToInvoke = HolographyTowerToPadConversationUtils.class.getMethod("privateHydrateHolographyTowerToPad", HolographyTowerToPad.class);
		ConversationInterceptor conversationInterceptor = TmcdbContextFactory.INSTANCE.getConversationInterceptor();
		Object[] args = new Object[1];
		args[0] = a2p;
		conversationInterceptor.invoke(methodToInvoke, this, args);
	}
	
	public ConversationTokenProvider privateHydrateHolographyTowerToPad(HolographyTowerToPad a2p)
	{
		ConversationTokenProvider retVal = new ConversationTokenProviderAdapter(ConversationToken.CONVERSATION_COMPLETED);
		HolographyTowerToPadService h2pService =  TmcdbContextFactory.INSTANCE.getHolographyTowerToPadService();	   
		h2pService.hydrate(a2p);
		return retVal;
	}
}
