/*******************************************************************************
  * ALMA - Atacama Large Millimeter Array
  * Copyright (c) NRAO - National Radio Astronomy Observatory, 2012
  * (in the framework of the ALMA collaboration).
  * All rights reserved.
  *
  * This library is free software; you can redistribute it and/or
  * modify it under the terms of the GNU Lesser General Public
  * License as published by the Free Software Foundation; either
  * version 2.1 of the License, or (at your option) any later version.
  *
  * This library is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this library; if not, write to the Free Software
  * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 
*******************************************************************************/
package alma.obops.tmcdbgui.utils.conversation;

import java.lang.reflect.Method;

import alma.acs.tmcdb.DomainsMapping;
import alma.acs.tmcdb.NotificationServiceMapping;
import alma.obops.dam.config.TmcdbContextFactory;
import alma.obops.dam.tmcdb.service.DomainsMappingService;
import alma.obops.dam.tmcdb.service.NotificationServiceMappingService;
import alma.obops.dam.utils.ConversationInterceptor;
import alma.obops.dam.utils.ConversationTokenProvider;
import alma.obops.dam.utils.ConversationTokenProviderAdapter;
import alma.obops.dam.utils.ConversationTokenProvider.ConversationToken;

/**
 * @author sharring
 *
 */
public class DomainsMappingConversationUtils 
{
	private static DomainsMappingConversationUtils singletonInstance;
	
	private DomainsMappingConversationUtils() 
	{
	}
	
	public static synchronized DomainsMappingConversationUtils getInstance()
	{
		if(null == singletonInstance)
		{
			singletonInstance = new DomainsMappingConversationUtils();
		}
		
		return singletonInstance;
	}
	
	public void hydrateDomainsMappings(NotificationServiceMapping parent) 
	throws Exception
	{
		Method methodToInvoke = DomainsMappingConversationUtils.class.getMethod("privateHydrateDomainsMappings", NotificationServiceMapping.class);	
		ConversationInterceptor conversationInterceptor = TmcdbContextFactory.INSTANCE.getConversationInterceptor();
		Object[] args = new Object[1];
		args[0] = parent;
		conversationInterceptor.invoke(methodToInvoke, this, args);
	}

	public ConversationTokenProvider privateHydrateDomainsMappings(NotificationServiceMapping parent)
	{
		ConversationTokenProvider retVal = new ConversationTokenProviderAdapter(ConversationToken.CONVERSATION_COMPLETED);
		NotificationServiceMappingService service = TmcdbContextFactory.INSTANCE.getNotificationServiceMappingService();
		service.hydrateDomainsMappings(parent);
		return retVal;
	}
	
	public void saveOrUpdateDomainsMapping(DomainsMapping domainsMapping) throws Exception 
	{
		Method methodToInvoke = DomainsMappingConversationUtils.class.getMethod("privateSaveOrUpdateDomainsMapping", DomainsMapping.class);	
		ConversationInterceptor conversationInterceptor = TmcdbContextFactory.INSTANCE.getConversationInterceptor();
		Object[] args = new Object[1];
		args[0] = domainsMapping;
		conversationInterceptor.invoke(methodToInvoke, this, args);
	}

	public ConversationTokenProvider privateSaveOrUpdateDomainsMapping(DomainsMapping domainsMapping) {
		ConversationTokenProvider retVal = new ConversationTokenProviderAdapter(ConversationToken.CONVERSATION_COMPLETED);
		DomainsMappingService service = TmcdbContextFactory.INSTANCE.getDomainsMappingService();
		service.update(domainsMapping);
		return retVal;
	}
	
	public ConversationTokenProvider privateDeleteDomainsMapping(DomainsMapping toDelete, ConversationToken token) {
		ConversationTokenProvider retVal = new ConversationTokenProviderAdapter(token);
		DomainsMappingService service = TmcdbContextFactory.INSTANCE.getDomainsMappingService();
		service.delete(toDelete);
		return retVal;
	}
}
