/*******************************************************************************
  * ALMA - Atacama Large Millimeter Array
  * Copyright (c) NRAO - National Radio Astronomy Observatory, 2012
  * (in the framework of the ALMA collaboration).
  * All rights reserved.
  *
  * This library is free software; you can redistribute it and/or
  * modify it under the terms of the GNU Lesser General Public
  * License as published by the Free Software Foundation; either
  * version 2.1 of the License, or (at your option) any later version.
  *
  * This library is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this library; if not, write to the Free Software
  * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 
*******************************************************************************/
package alma.obops.tmcdbgui.utils.conversation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

import alma.acs.tmcdb.ComponentType;
import alma.obops.dam.config.TmcdbContextFactory;
import alma.obops.dam.tmcdb.service.ComponentTypeService;
import alma.obops.dam.utils.ConversationInterceptor;
import alma.obops.dam.utils.ConversationTokenProvider;
import alma.obops.dam.utils.ConversationTokenProviderAdapter;
import alma.obops.dam.utils.ConversationTokenProvider.ConversationToken;

/**
 * @author sharring
 *
 */
public class ComponentTypeConversationUtils 
{
	private static ComponentTypeConversationUtils singletonInstance;

	private ComponentTypeConversationUtils() 
	{
	}

	public static synchronized ComponentTypeConversationUtils getInstance()
	{
		if(null == singletonInstance)
		{
			singletonInstance = new ComponentTypeConversationUtils();
		}

		return singletonInstance;
	}
	
	public void saveOrUpdate(ComponentType compType) throws Exception 
	{
		Method methodToInvoke = ComponentTypeConversationUtils.class.getMethod("privateSaveOrUpdate", ComponentType.class);	
		ConversationInterceptor conversationInterceptor = TmcdbContextFactory.INSTANCE.getConversationInterceptor();
		Object[] args = new Object[1];
		args[0] = compType;
		conversationInterceptor.invoke(methodToInvoke, this, args);
	}

	public ConversationTokenProvider privateSaveOrUpdate(ComponentType compType) 
	{
		ConversationTokenProvider retVal = new ConversationTokenProviderAdapter(ConversationToken.CONVERSATION_COMPLETED);
		ComponentTypeService service = TmcdbContextFactory.INSTANCE.getComponentTypeService();
		service.update(compType);
		return retVal;
	}
	
	public List<ComponentType> findByNameExactMatch(String idl) throws Exception 
	{
		List<ComponentType> retVal = new ArrayList<ComponentType>();
		Method methodToInvoke = ComponentTypeConversationUtils.class.getMethod("privateFindByNameExactMatch", String.class, 
				ComponentTypeListHolder.class);	
		ConversationInterceptor conversationInterceptor = TmcdbContextFactory.INSTANCE.getConversationInterceptor();
		Object[] args = new Object[2];
		args[0] = idl;
		ComponentTypeListHolder resultHolder = new ComponentTypeListHolder();
		args[1] = resultHolder;
		conversationInterceptor.invoke(methodToInvoke, this, args);
		retVal = resultHolder.getComponentTypes();
		return retVal;
	}

	@SuppressWarnings("unchecked")
	public ConversationTokenProvider privateFindByNameExactMatch(String idl, ComponentTypeListHolder resultHolder) {
		ConversationTokenProvider retVal = new ConversationTokenProviderAdapter(ConversationToken.CONVERSATION_COMPLETED);
		ComponentTypeService service = TmcdbContextFactory.INSTANCE.getComponentTypeService();
		resultHolder.setComponentTypes((List<ComponentType>) service.findByNameExactMatch(idl));
		return retVal;
	}
	
	public List<ComponentType> findByName(String idl) throws Exception 
	{
		List<ComponentType> retVal = new ArrayList<ComponentType>();
		Method methodToInvoke = ComponentTypeConversationUtils.class.getMethod("privateFindByName", String.class, 
				ComponentTypeListHolder.class);	
		ConversationInterceptor conversationInterceptor = TmcdbContextFactory.INSTANCE.getConversationInterceptor();
		Object[] args = new Object[2];
		args[0] = idl;
		ComponentTypeListHolder resultHolder = new ComponentTypeListHolder();
		args[1] = resultHolder;
		conversationInterceptor.invoke(methodToInvoke, this, args);
		retVal = resultHolder.getComponentTypes();
		return retVal;
	}

	@SuppressWarnings("unchecked")
	public ConversationTokenProvider privateFindByName(String idl, ComponentTypeListHolder resultHolder) {
		ConversationTokenProvider retVal = new ConversationTokenProviderAdapter(ConversationToken.CONVERSATION_COMPLETED);
		ComponentTypeService service = TmcdbContextFactory.INSTANCE.getComponentTypeService();
		resultHolder.setComponentTypes((List<ComponentType>) service.findByName(idl));
		return retVal;
	}
	
	private class ComponentTypeListHolder
	{
		private List<ComponentType> componentTypes;
		public List<ComponentType> getComponentTypes() { return this.componentTypes; }
		public void setComponentTypes(List<ComponentType> compTypes) { this.componentTypes = compTypes; }
	}

	/**
	 * @param criteria
	 * @param object
	 * @return
	 */
	public List<?> find(List<Object> searchCriteria, List<Object> orderCriteria) throws Exception 
	{
		Method methodToInvoke = ComponentTypeConversationUtils.class.getMethod("privateFind", List.class, List.class, ComponentTypeListHolder.class);	
		ConversationInterceptor conversationInterceptor = TmcdbContextFactory.INSTANCE.getConversationInterceptor();
		Object[] args = new Object[3];
		args[0] = searchCriteria;
		args[1] = orderCriteria;
		ComponentTypeListHolder resultHolder = new ComponentTypeListHolder();
		args[2] = resultHolder;
		conversationInterceptor.invoke(methodToInvoke, this, args);
		return resultHolder.getComponentTypes();
	}

	@SuppressWarnings("unchecked")
	public ConversationTokenProvider privateFind(List searchCriteria, List orderCriteria, ComponentTypeListHolder resultHolder)
	{
		ConversationTokenProvider retVal = new ConversationTokenProviderAdapter(ConversationToken.CONVERSATION_COMPLETED);
		ComponentTypeService service = TmcdbContextFactory.INSTANCE.getComponentTypeService();
		resultHolder.setComponentTypes((List<ComponentType>) service.find(searchCriteria, orderCriteria));
		return retVal;
	}
}
