/*******************************************************************************
  * ALMA - Atacama Large Millimeter Array
  * Copyright (c) NRAO - National Radio Astronomy Observatory, 2012
  * (in the framework of the ALMA collaboration).
  * All rights reserved.
  *
  * This library is free software; you can redistribute it and/or
  * modify it under the terms of the GNU Lesser General Public
  * License as published by the Free Software Foundation; either
  * version 2.1 of the License, or (at your option) any later version.
  *
  * This library is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this library; if not, write to the Free Software
  * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 
*******************************************************************************/
package alma.obops.tmcdbgui.utils.conversation;

import java.lang.reflect.Method;

import alma.acs.tmcdb.ChannelMapping;
import alma.acs.tmcdb.NotificationServiceMapping;
import alma.obops.dam.config.TmcdbContextFactory;
import alma.obops.dam.tmcdb.service.ChannelMappingService;
import alma.obops.dam.tmcdb.service.NotificationServiceMappingService;
import alma.obops.dam.utils.ConversationInterceptor;
import alma.obops.dam.utils.ConversationTokenProvider;
import alma.obops.dam.utils.ConversationTokenProviderAdapter;
import alma.obops.dam.utils.ConversationTokenProvider.ConversationToken;

/**
 * @author sharring
 *
 */
public class ChannelMappingConversationUtils 
{
	private static ChannelMappingConversationUtils singletonInstance;
	
	private ChannelMappingConversationUtils() 
	{
	}
	
	public static synchronized ChannelMappingConversationUtils getInstance()
	{
		if(null == singletonInstance)
		{
			singletonInstance = new ChannelMappingConversationUtils();
		}
		
		return singletonInstance;
	}
	
	public void hydrateChannelMappings(NotificationServiceMapping parent) throws Exception
	{
		Method methodToInvoke = ChannelMappingConversationUtils.class.getMethod("privateHydrateChannelMappings", NotificationServiceMapping.class);	
		ConversationInterceptor conversationInterceptor = TmcdbContextFactory.INSTANCE.getConversationInterceptor();
		Object[] args = new Object[1];
		args[0] = parent;
		conversationInterceptor.invoke(methodToInvoke, this, args);
	}

	public ConversationTokenProvider privateHydrateChannelMappings(NotificationServiceMapping parent)
	{
		ConversationTokenProvider retVal = new ConversationTokenProviderAdapter(ConversationToken.CONVERSATION_COMPLETED);
		NotificationServiceMappingService service = TmcdbContextFactory.INSTANCE.getNotificationServiceMappingService();
		service.hydrateChannelMappings(parent);
		return retVal;
	}
	
	public void saveOrUpdateChannelMapping(ChannelMapping channelMapping) throws Exception 
	{
		Method methodToInvoke = ChannelMappingConversationUtils.class.getMethod("privateSaveOrUpdateChannelMapping", ChannelMapping.class);	
		ConversationInterceptor conversationInterceptor = TmcdbContextFactory.INSTANCE.getConversationInterceptor();
		Object[] args = new Object[1];
		args[0] = channelMapping;
		conversationInterceptor.invoke(methodToInvoke, this, args);
	}

	public ConversationTokenProvider privateSaveOrUpdateChannelMapping(ChannelMapping channelMapping) {
		ConversationTokenProvider retVal = new ConversationTokenProviderAdapter(ConversationToken.CONVERSATION_COMPLETED);
		ChannelMappingService service = TmcdbContextFactory.INSTANCE.getChannelMappingService();
		service.update(channelMapping);
		return retVal;
	}
	
	public ConversationTokenProvider privateDeleteChannelMapping(ChannelMapping toDelete, ConversationToken token) {
		ConversationTokenProvider retVal = new ConversationTokenProviderAdapter(token);
		ChannelMappingService service = TmcdbContextFactory.INSTANCE.getChannelMappingService();
		service.delete(toDelete);
		return retVal;
	}
	
}
