/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.utils;

import alma.tmcdb.domain.AntennaType;

/**
 * Utility class housing useful constants related to antennas.
 * @author sharring
 */
public class TmcdbConstants 
{
	// these are publicly, rather then privately, scoped to allow the antennacomponentwizardpage to use them
	public static final String CM = "CM";
	public static final String PM = "PM";
	public static final String DV = "DV";
	public static final String DA = "DA";
	
	public static final String _7M = "7m";
	public static final String _12M = "12m";
	public static final String ACA = AntennaType.ACA.name();
	public static final String VA = AntennaType.VA.name();
	public static final String AEC = AntennaType.AEC.name();
	public static final String LA = "LA"; // see COMP-5134
	public static final String[] ANTENNA_DIAMETER_ACA_ARRAY = new String[]{_12M, _7M};
	public static final String[] NAME_PREFIX_ARRAY = new String[] { DA, DV, LA, PM, CM};
	
	public final static String[] DV_NUMBERS = { "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", 
		"11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25"};
	
	public final static String[] DA_NUMBERS = { "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", 
		"51", "52", "53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", "64", "65"};
	
	public final static String[] PM_NUMBERS = { "01", "02", "03", "04" };
	
	public final static String[] CM_NUMBERS = { "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12" };
	public static final String SCI_NOTATION_REGEXP = "[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?";
	public static final String CONTROL_PREFIX = "CONTROL";
	public static final String SLASH = "/";
	public static final String FRONTEND = "FrontEnd";
	public static final String WEATHERSTATION = "WeatherStationController";
}
