/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.utils;

import java.util.Date;

import org.eclipse.core.databinding.conversion.Converter;

import alma.acs.util.UTCUtility;

/**
 * Converter to convert between Date objects in the GUI
 * (e.g. DateTime widget) and
 * Long values required by the POJO's (e.g. Pad's commissionDate property)
 * 
 * @author sharrington
 */
public class JavaDateToAcsTimeLongConverter extends Converter 
{

	public JavaDateToAcsTimeLongConverter() {
		super(Date.class, Long.class);
	}

	@Override
	public Object convert(Object objToConvert) {
		Long retVal = null;
		if(null != objToConvert && objToConvert instanceof Date) {
		    Date dateToConvert = (Date) objToConvert;
		    // TODO: do we need to be converting these to / from Acs time?!?!
		    retVal = UTCUtility.utcJavaToOmg(dateToConvert.getTime());
		}
		
		return retVal;
	}

}
