/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.utils;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

import alma.acs.tmcdb.AcsService;
import alma.acs.tmcdb.BACIProperty;
import alma.acs.tmcdb.ChannelMapping;
import alma.acs.tmcdb.Component;
import alma.acs.tmcdb.ComponentType;
import alma.acs.tmcdb.Computer;
import alma.acs.tmcdb.Configuration;
import alma.acs.tmcdb.Container;
import alma.acs.tmcdb.ContainerStartupOption;
import alma.acs.tmcdb.DefaultCanAddress;
import alma.acs.tmcdb.DomainsMapping;
import alma.acs.tmcdb.EventChannel;
import alma.acs.tmcdb.Manager;
import alma.acs.tmcdb.NotificationServiceMapping;
import alma.acs.tmcdb.translator.TmcdbObject;
import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;

/**
 * Class with methods for getting the correct {@link Image} or {@link ImageDescriptor} object
 * depending on the given object.
 *
 * @author rtobar, Mar 24, 2010
 *
 */
public class ImageHelper {

	private static final String ACS_SERVICE = "icons/service.png";
	private static final String NOTIFICATION_CHANNEL = "icons/nc.png";
	private static final String NOTIFICATION_SERVICE_MAPPING = "icons/notificationservice-mapping.gif";
	private static final String DOMAINS_MAPPING = "icons/domain-mapping.png";
	private static final String CHANNEL_MAPPING = "icons/channel-mapping.gif";
	private static final String DEFAULTCANADDRESS = "icons/default-can-address.gif";
	private static final String COMPONENT = "icons/component.png";
	private static final String COMPONENT_TYPE = "icons/component-type.png";
	private static final String COMPUTER = "icons/computer.gif";
	private static final String CONFIGURATION = "icons/configuration.png";
	private static final String CONTAINER = "icons/container.gif";
	private static final String CONTAINERSTARTUPOPTION = "icons/containerstartupoption.png";
	private static final String BACIPROPERTY = "icons/baci-property.gif";
	private static final String MANAGER = "icons/manager.png";

	public static Image getImage(TmcdbObject c) {
		return RcpUtils.getImage(imageFileFor(c));
	}

	public static ImageDescriptor getImageDescriptor(TmcdbObject c) {
		return RcpUtils.getImageDescriptor(imageFileFor(c));
	}

	/***** Private methods. One method to handle generically, several for case to case *****/
	private static String imageFileFor(TmcdbObject o) {
		if( o instanceof Component )
			return imageFileFor((Component)o);
		else if( o instanceof ComponentType )
			return imageFileFor((ComponentType)o);
		else if( o instanceof Container )
			return imageFileFor((Container)o);
		else if( o instanceof ContainerStartupOption )
			return imageFileFor((ContainerStartupOption)o);
		else if( o instanceof Configuration )
			return imageFileFor((Configuration)o);
		else if( o instanceof Computer )
			return imageFileFor((Computer)o);
		else if( o instanceof EventChannel )
			return imageFileFor((EventChannel)o);
		else if( o instanceof BACIProperty )
			return imageFileFor((BACIProperty)o);
		else if( o instanceof DefaultCanAddress )
			return imageFileFor((DefaultCanAddress)o);
		else if( o instanceof AcsService )
			return imageFileFor((AcsService)o);
		else if( o instanceof Manager )
			return imageFileFor((Manager)o);
		else if( o instanceof NotificationServiceMapping )
			return imageFileFor((NotificationServiceMapping)o);
		else if( o instanceof ChannelMapping )
			return imageFileFor((ChannelMapping)o);
		else if( o instanceof DomainsMapping )
			return imageFileFor((DomainsMapping)o);
		return "";
	}

	private static String imageFileFor(@SuppressWarnings("unused") ContainerStartupOption o) {
		return CONTAINERSTARTUPOPTION;
	}

	private static String imageFileFor(@SuppressWarnings("unused") DefaultCanAddress dca) {
		return DEFAULTCANADDRESS;
	}

	private static String imageFileFor(@SuppressWarnings("unused") BACIProperty bp) {
		return BACIPROPERTY;
	}

	private static String imageFileFor(@SuppressWarnings("unused") Component c) {
    	return COMPONENT;
	}

	private static String imageFileFor(@SuppressWarnings("unused") AcsService o) {
		return ACS_SERVICE;
	}
	
	private static String imageFileFor(@SuppressWarnings("unused") NotificationServiceMapping o) {
		return NOTIFICATION_SERVICE_MAPPING;
	}
	
	private static String imageFileFor(@SuppressWarnings("unused") ChannelMapping o) {
		return CHANNEL_MAPPING;
	}
	
	private static String imageFileFor(@SuppressWarnings("unused") DomainsMapping o) {
		return DOMAINS_MAPPING;
	}
	
	private static String imageFileFor(@SuppressWarnings("unused") ComponentType ct) {
		return COMPONENT_TYPE;
	}

	private static String imageFileFor(@SuppressWarnings("unused") Container c) {
		return CONTAINER;
	}

	private static String imageFileFor(@SuppressWarnings("unused") Configuration c) {
		return CONFIGURATION;
	}

	private static String imageFileFor(@SuppressWarnings("unused") Computer c) {
		return COMPUTER;
	}
	
	private static String imageFileFor(@SuppressWarnings("unused") Manager c) {
		return MANAGER;
	}

	private static String imageFileFor(@SuppressWarnings("unused") EventChannel c) {
		return NOTIFICATION_CHANNEL;
	}
}
