/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.utils;

import alma.tmcdb.domain.BaseElementStartup;
import alma.tmcdb.domain.BaseElementStartupType;
import alma.tmcdb.domain.BaseElementType;

/**
 * New utility class for domain object things. 
 * TODO: consolidate utility classes?
 * @author sharring
 */
public class DomainObjectUtils
{
   private DomainObjectUtils() {}
   
   public static BaseElementStartup determineRootOfBaseElementTree(BaseElementStartup bes) 
	{
		// "generic" baseelementstartup objects have no associated startup reference;
		// instead, they have a parent, which eventually resolves to a startup reference. 
		// let's loop to find the startup, using the parent(s) hierarchy:
		BaseElementStartup rootOfTree = bes;
		while(null == rootOfTree.getStartup()) {
			rootOfTree = rootOfTree.getParent();
		}

		// if the top of the hierarchy still didn't have a startup reference, then
		// there is a problem with the DB as this is not a valid state!
		if(null == rootOfTree.getStartup()) {
			throw new IllegalStateException("BaseElementStartup hierarchy does not belong to a startup; DB is corrupt.");
		}
		return rootOfTree;
	}

public static BaseElementStartupType getBaseElementStartupTypeFromBaseElementType(BaseElementType betype) 
{
	BaseElementStartupType retVal = null;

	// Note: only top-level baseelementstartup types need to be handled here; sub-baseelements (frontend, photonicref, etc)
	// will never call the addBaseElementToStartupScenario method.
	switch(betype)
	{
	case AOSTiming:
		retVal = BaseElementStartupType.AOSTiming;
		break;
	case Antenna:
		retVal = BaseElementStartupType.Antenna;
		break;
	case CentralLO:
		retVal = BaseElementStartupType.CentralLO;
		break;
	case WeatherStationController:
		retVal = BaseElementStartupType.WeatherStationController;
		break;
	case Array:
		retVal = BaseElementStartupType.Array;
		break;
	case FrontEnd:
		retVal = BaseElementStartupType.FrontEnd;
		break;
	case HolographyTower:
		retVal = BaseElementStartupType.HolographyTower;
		break;
	case Pad:
		retVal = BaseElementStartupType.Pad;
		break;
	case PhotonicReference:
		retVal = BaseElementStartupType.PhotonicReference1;
		break;
	case AcaCorrSet:
	case CorrQuadrant:
		break;
	}

	return retVal;
}
}
