/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.utils;

import alma.ReceiverBandMod.ReceiverBand;

public class DelayEditingUtils 
{
   private DelayEditingUtils() 
   {
	   // disallow construction; this class has all static methods
   }
   
   public static ReceiverBand getReceiverBandForValue(int i) 
	{
		ReceiverBand retVal = null;
		
		switch(i)
		{
		case 0:
			retVal = ReceiverBand.ALMA_RB_01;
			break;
		case 1:
			retVal = ReceiverBand.ALMA_RB_02;
			break;
		case 2:
			retVal = ReceiverBand.ALMA_RB_03;
			break;
		case 3:
			retVal = ReceiverBand.ALMA_RB_04;
			break;
		case 4:
			retVal = ReceiverBand.ALMA_RB_05;
			break;
		case 5:
			retVal = ReceiverBand.ALMA_RB_06;
			break;
		case 6:
			retVal = ReceiverBand.ALMA_RB_07;
			break;
		case 7:
			retVal = ReceiverBand.ALMA_RB_08;
			break;
		case 8:
			retVal = ReceiverBand.ALMA_RB_09;
			break;
		case 9:
			retVal = ReceiverBand.ALMA_RB_10;
			break;
		default:
			throw new IllegalArgumentException("ALMA supports only 10 receiver bands, value out of range");
		}
		
		return retVal;
	}

   
   public static int getIntFromReceiverBandEnum(ReceiverBand receiverBand) 
   {
		int retVal = -1;
		
		if(receiverBand.equals(ReceiverBand.ALMA_RB_01))
		{
			retVal = 0;
		}
		else if(receiverBand.equals(ReceiverBand.ALMA_RB_02))
		{
			retVal = 1;
		}
		else if(receiverBand.equals(ReceiverBand.ALMA_RB_03))
		{
			retVal = 2;
		}
		else if(receiverBand.equals(ReceiverBand.ALMA_RB_04))
		{
			retVal = 3;
		}
		else if(receiverBand.equals(ReceiverBand.ALMA_RB_05))
		{
			retVal = 4;
		}
		else if(receiverBand.equals(ReceiverBand.ALMA_RB_06))
		{
			retVal = 5;
		}
		else if(receiverBand.equals(ReceiverBand.ALMA_RB_07))
		{
			retVal = 6;
		}
		else if(receiverBand.equals(ReceiverBand.ALMA_RB_08))
		{
			retVal = 7;
		}
		else if(receiverBand.equals(ReceiverBand.ALMA_RB_09))
		{
			retVal = 8;
		}
		else if(receiverBand.equals(ReceiverBand.ALMA_RB_10))
		{
			retVal = 9;
		}
		else 
		{
			throw new IllegalStateException("ALMA only supports 10 receiver bands, but enum has more.");
		}
		
		return retVal;
	}
}
