/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * BackendUtils.java
 *
 * Copyright European Southern Observatory 2008
 */

package alma.obops.tmcdbgui.utils;

import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

import alma.archive.database.helpers.wrappers.DbConfigException;
import alma.obops.dam.config.TmcdbContextFactory;
import alma.obops.tmcdbgui.TmcdbGui;

/**
 * A collection of static methods and constants to manage the connection to our
 * backend database.
 *
 * @author amchavan, Nov 21, 2008
 * 
 */



public class BackendUtils {

    /** Name of the .cfg.xml resource defining our environment */
    private static final String
        SPRING_CONFIG = "config" + "/" + "tmcdbExplorerAppContext.xml";

    /**
     * @return A stream opened for input on the DB properties file to use for
     *         connecting to our back-end.
     */
    public static InputStream getDbConfigProperties(String propertiesFile) {
        ClassLoader cl = BackendUtils.class.getClassLoader();
        return cl.getResourceAsStream( propertiesFile );
    }

    /**
     * Set up a connection to our backend database, and initialize our service
     * factory.
     *
     * @throws DbConfigException
     */
    public static void initializeBackend() throws DbConfigException
    {
    	Logger logger = TmcdbGui.getLogger();
    	Level level = logger.getLevel();
    	logger.setLevel(Level.INFO);
        TmcdbContextFactory.INSTANCE.init( SPRING_CONFIG, logger, BackendUtils.class.getClassLoader());
        logger.setLevel(level);
    }

    /**
     * Set up a connection to our backend database, and initialize our service
     * factory.
     *
     * @throws DbConfigException
     */
    public static void initializeBackendForTesting(Logger logger) throws DbConfigException {

    	if( logger == null )
    		logger = TmcdbGui.getLogger();

        if(!TmcdbContextFactory.INSTANCE.isInitialized()) {
           TmcdbContextFactory.INSTANCE.init( SPRING_CONFIG, logger, BackendUtils.class.getClassLoader());
        }

    }

}
