/*******************************************************************************
  * ALMA - Atacama Large Millimeter Array
  * Copyright (c) NRAO - National Radio Astronomy Observatory, 2012
  * (in the framework of the ALMA collaboration).
  * All rights reserved.
  *
  * This library is free software; you can redistribute it and/or
  * modify it under the terms of the GNU Lesser General Public
  * License as published by the Free Software Foundation; either
  * version 2.1 of the License, or (at your option) any later version.
  *
  * This library is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this library; if not, write to the Free Software
  * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 
*******************************************************************************/
package alma.obops.tmcdbgui.utils;

import alma.tmcdb.domain.AntennaToPad;

/**
 * @author sharring
 *
 */
public class AntennaToPadUtils 
{
	public static String getAntennaToPadIdentifier(AntennaToPad a2p)
	{
		String antennaName = a2p.getAntenna().getName();
		String padName = a2p.getPad().getName();
		if(!a2p.getPad().getConfiguration().getId().equals(a2p.getAntenna().getConfiguration().getId())) {
			String qualifiedPadName = a2p.getPad().getConfiguration().getName() + ":" + padName;
			padName = qualifiedPadName;
		}
		String identifier = antennaName + " on " + padName;
		return identifier;
	}
}
