/*
 * ALMA - Atacama Large Millimiter Array (c) European Southern Observatory, 2011
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package alma.obops.tmcdbgui.ui;

import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.hibernate.Hibernate;

import alma.acs.tmcdb.Component;
import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;

/**
 * A label decorator to overlays a warning icon in the Component icon
 * if its ImplLang field is different from its container's ImplLang.
 *
 * @author  rtobar, Nov 11, 2011
 */
public class ComponentImplLangLabelDecorator extends LabelProvider implements
		ILightweightLabelDecorator {

	public static final String ID = "alma.obops.tmcdb.explorer.componentImplLangDecorator";

	@Override
	public void decorate(Object element, final IDecoration decoration) {

		if( element == null )
			return;

		if( element instanceof Component ) {

			Component c = (Component) element;

			if( c.getImplLang() == null )
				return;

			if( c.getContainer() == null || !Hibernate.isInitialized(c.getContainer()) )
				return;

			// If the implementation language is the same, don't do anything
			if( c.getContainer().getImplLang().toString().equals(c.getImplLang().toString()))
				return;

			// OK, things are different, overlay the warning icon now
			decoration.addOverlay(RcpUtils.getImageDescriptor("icons/warning-overlay.png"), IDecoration.BOTTOM_LEFT);
		}

	}

}