/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;

import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;

public class TmcdbSearchResult implements ISearchResult {

	private ISearchQuery query;
	private List<ISearchResultListener> fListeners;
	private Map<TmcdbQueryTables, List<Object>> elements = new HashMap<TmcdbQueryTables, List<Object>>();

	public TmcdbSearchResult(ISearchQuery query) {
		this.query = query;
		fListeners = new ArrayList<ISearchResultListener>();
	}

	/**
	 * {@inheritDoc}
	 */
	public void addListener(ISearchResultListener l) {
		synchronized (fListeners) {
			fListeners.add(l);
		}
	}

	/**
	 * {@inheritDoc}
	 */
	public void removeListener(ISearchResultListener l) {
		synchronized (fListeners) {
			fListeners.remove(l);
		}
	}

	@Override
	public String getLabel() {
		return query.getLabel();
	}

	@Override
	public String getTooltip() {
		return "Query to search objects in the TMCDB tables";
	}

	@Override
	public ImageDescriptor getImageDescriptor() {
		return RcpUtils.getImageDescriptor("icons/sql.gif");
	}

	@Override
	public ISearchQuery getQuery() {
		return query;
	}

	public void addElement(TmcdbQueryTables table, Object o) {
		if( !elements.containsKey(table) )
			elements.put(table, new ArrayList<Object>());
		elements.get(table).add(o);
	}

	public Map<TmcdbQueryTables, List<Object>> getElements() {
		return elements;
	}

	public void clear() {
		elements.clear();
	}

	public void publishResults() {
		for(ISearchResultListener l: fListeners)
			l.searchResultChanged(null);
	}
}