/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * ResultSetSpreadsheet.java
 *
 * Copyright European Southern Observatory 2008
 */

package alma.obops.tmcdbgui.rsviewer;

import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

import alma.obops.dam.config.TmcdbContextFactory;


/**
 * A spreadsheet-like table viewer for displaying a result set
 *
 * @author amchavan, Aug 29, 2008
 * 
 */



public class ResultSetViewer 
    extends TableViewer 
    implements ResultSetCallback {

    protected static final String WARNING_ICON = "icons/warning.png";
    protected static final String SQL_NULL = "null";
    protected ResultSetCallback callback;
    protected static Image warning;

    /**
     * Creates a spreadsheet-like table viewer on a newly-created table control
     * under the given parent, for displaying a result set. The table control is
     * created using the given style bits. <br/>
     * 
     * The viewer has no contents until the
     * {@link #setData(ResultSet, ResultSetCallback)} method is called.
     * 
     * @param parent  the parent control
     * @param style   SWT style bits
     */
    public ResultSetViewer( Composite parent, int style ) {
        
        super( parent, style );
        
        Table table = getTable();
        table.setHeaderVisible( true );
        table.setLinesVisible( true );

        if( warning == null ) {
            ClassLoader cl = this.getClass().getClassLoader();
            InputStream stream = cl.getResourceAsStream( WARNING_ICON );
            warning = new Image( table.getDisplay(), stream );
        }
        
        setContentProvider( new ResultSetContentsProvider() );
        setLabelProvider( new ResultSetLabelProvider() );

//        setCellModifier(new ICellModifier() {
//
//            /**
//             * @see org.eclipse.jface.viewers.ICellModifier#canModify(java.lang.Object, java.lang.String)
//             */
//            public boolean canModify( Object element, String property ) {
//                // we can edit all cells
//                return true;
//            }
//
//            /**
//             * @see org.eclipse.jface.viewers.ICellModifier#getValue(java.lang.Object,java.lang.String)
//             */
//            public Object getValue( Object element, String property ) {
//                int index = Integer.parseInt( property );
//                Object[] row = (Object[]) element;
//                return row[index].toString();
//            }
//
//            /* (non-Javadoc)
//             * @see org.eclipse.jface.viewers.ICellModifier#modify(java.lang.Object, java.lang.String, java.lang.Object)
//             */
//            public void modify( Object element, String property, Object value ) {
//
//                // Convert our input to something more meaningful
//                int col = Integer.parseInt( property );
//                TableItem item = (TableItem) element;
//                String newText = value.toString();
//                
//                Table table = item.getParent();
//                int row = table.indexOf( item );
//                String oldText = item.getText( col );
//                if (!oldText.equals( newText )) {
//
//                    item.setImage( col, warning );
//                    item.setText( col, newText );
//
//                    // Note that table indices start at zero, while ResultSet
//                    // indices start at one -- need to take care of that
//                    // conversion
//                    // here
//                    callback.updateResultSet( row + 1, col + 1, newText );
//                }
//            }
//
//        } );

    }

    /**
     * @param parent
     * @param style
     * @throws SQLException 
     */
    public void setData( String tableName, List<List<Object>> data, ResultSetCallback callback ) {
        
        this.callback = callback;
        
        Table table = getTable();
        
        // get rid of any existing columns
        while( table.getColumns().length > 0 ) {
            table.getColumns()[0].dispose();
        }

//        // get rid of any existing control editors
//        Control controlEditor = editor.getEditor();
//        if( controlEditor != null ) {
//            controlEditor.dispose();
//        }
        
        List<String> columnNames = TmcdbContextFactory.INSTANCE.getHibernateUtils().getColumnNames(null, tableName);
        int numCols = columnNames.size();
		TableColumn[] columns = new TableColumn[numCols];
        for( int i = 0; i < numCols; i++ ) {
            columns[i] = new TableColumn( table, SWT.NONE );
            columns[i].setText( columnNames.get(i));
        }

        CellEditor[] editors = new CellEditor[numCols];
        String[] properties = new String[numCols];
        for( int i = 0; i < numCols; i++ ) {
            editors[i] = new TextCellEditor( getTable() );
            properties[i] = Integer.toString( i );
        }
        setCellEditors( editors );
        setColumnProperties( properties );

        setInput( data );
        for( int i = 0; i < numCols; i++ ) {
            columns[i].pack();
        }
    }

    /**
     * Simply delegate to our callback.
     * @see alma.obops.rpcsandbox.spreadsheet.ResultSetCallback#updateResultSet(int, int, java.lang.String)
     */
    public void updateResultSet( int row, int column, String newvalue ) {
//        callback.updateResultSet( row, column, newvalue );
    }
}
