/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * ResultSetContentsProvider.java
 *
 * Copyright European Southern Observatory 2008
 */

package alma.obops.tmcdbgui.rsviewer;

import java.util.List;

import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;


/**
 * TODO Javadoc for this type
 *
 * @author amchavan, Aug 29, 2008
 * 
 */



public class ResultSetContentsProvider implements IStructuredContentProvider {

    public void dispose() {
        // no-op
    }

    @Override
    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
    }

    /**
     * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
     */
    @SuppressWarnings("unchecked")
	public Object[] getElements( Object input ) {

    	List<List<Object>> data = (List<List<Object>>)input;

    	Object[][] dataAsArray = new Object[data.size()][];
        for(int i=0; i!= dataAsArray.length; i++) {
        	List<Object> rowData = data.get(i);
        	Object[] rowDataArray = rowData.toArray(new Object[rowData.size()]);
        	for(int j= 0; j!= rowDataArray.length; j++)
        		if( rowDataArray[j] == null )
        			rowDataArray[j] = ResultSetViewer.SQL_NULL;
        	dataAsArray[i] = rowDataArray;
		}

        // Shouldn't happen
        return dataAsArray;
    }
}