/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.rcp;


import java.awt.Dimension;

import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IWorkbenchPreferenceConstants;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;

import alma.archive.database.helpers.wrappers.DbConfigException;
import alma.obops.dam.config.TmcdbContextFactory;
import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.utils.BackendUtils;
import alma.obops.tmcdbgui.utils.GuiUtils;
import alma.obops.tmcdbgui.views.SQLLogConsole;
import alma.obops.tmcdbgui.views.dnd.EditorAreaDropAdapter;
import alma.obops.tmcdbgui.views.dnd.TmcdbObjectTransfer;

/**
 * @author amchavan, Sep 3, 2008 -- generated by the wizard.
 * 
 */



public class ApplicationWorkbenchWindowAdvisor extends WorkbenchWindowAdvisor {

    public static final int INITIAL_HEIGHT = 600;
    public static final int INITIAL_WIDTH = 800;
    
    // a static instance variable so that outside parties can 
    // get a 'handle' to the ApplicationActionBarAdvisor if necessary
    private static ApplicationActionBarAdvisor advisor;

    public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public synchronized ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) 
    {
    	if(null == advisor)
    	{
    		advisor = new ApplicationActionBarAdvisor(configurer);
    	}
        return advisor;
    }
    
    /**
     * Utility static method to get a reference to the ApplicationActionBarAdvisor.
     * @return the applicationactionbaradvisor instance
     */
    public static ApplicationActionBarAdvisor getAdvisor() {
    	return advisor;
    }

    /**
     * Do a number of initializations before we start up, including connecting
     * to our database backend.
     *
     * @see org.eclipse.ui.application.WorkbenchWindowAdvisor#preWindowOpen()
     */
    public void preWindowOpen() {

        // try connecting to our database backend
        try {
            BackendUtils.initializeBackend();
        }
        catch( DbConfigException e ) {
            e.printStackTrace();
            String errMsg = e.getMessage().contains("Could not find archiveConfig.properties.") ?
            		"Could not find archiveConfig.properties file; see ARCHIVE documentation for details on configuring the ALMA archive." : e.getMessage();
            GuiUtils.showErrorDialog( null, "Initialization error", errMsg);

            getWindowConfigurer().getWorkbenchConfigurer().emergencyClose();
            return;
        }

        IWorkbenchWindowConfigurer configurer = getWindowConfigurer();
        Dimension dim = java.awt.Toolkit.getDefaultToolkit().getScreenSize();

        StringBuilder title = new StringBuilder("TMCDB Explorer -- ");
        title.append( TmcdbContextFactory.INSTANCE.getConnectionUser() ).append('@');
        title.append( TmcdbContextFactory.INSTANCE.getConnectionLocation().replaceAll("//+", "") );
        
        configurer.setInitialSize( new Point(dim.width, dim.height) );
        configurer.setShowStatusLine( true );
        configurer.setShowProgressIndicator( true );
        configurer.setTitle(title.toString());

        RcpUtils.setWindowConfigurer( configurer );   // remember this

        boolean isGod = GuiUtils.isGodUser();
        configurer.setShowCoolBar( true );
        configurer.setShowMenuBar(isGod);	
        configurer.setShowPerspectiveBar( isGod );
        
        PlatformUI.getPreferenceStore()
                  .setValue( IWorkbenchPreferenceConstants.DOCK_PERSPECTIVE_BAR,
                             "TOP_RIGHT" );

    	configurer.addEditorAreaTransfer(TmcdbObjectTransfer.getInstance());
    	configurer.configureEditorAreaDropListener( new EditorAreaDropAdapter(configurer.getWindow()) );
    }

    public void postWindowOpen() {
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[] { new SQLLogConsole(getWindowConfigurer().getWindow()).getConsole() });
    }

	@Override
	public void postWindowClose() {
		TmcdbContextFactory.INSTANCE.shutdown();
	}


}
