/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.rcp;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;

import alma.obops.tmcdbgui.perspectives.ConfigurationsPerspective;
import alma.obops.tmcdbgui.ui.ComponentImplLangLabelDecorator;
import alma.obops.tmcdbgui.ui.TmcdbObjectIDLabelDecorator;

/**
 * @author amchavan, Sep 11, 2008, from the wizard
 * 
 */



public class ApplicationWorkbenchAdvisor extends WorkbenchAdvisor {

    public WorkbenchWindowAdvisor 
        createWorkbenchWindowAdvisor( IWorkbenchWindowConfigurer configurer ) {
        return new ApplicationWorkbenchWindowAdvisor( configurer );
    }

    public String getInitialWindowPerspectiveId() {
        return ConfigurationsPerspective.ID;
    }

    @Override
    public void initialize( IWorkbenchConfigurer configurer ) {
        super.initialize( configurer );

        try {
			configurer.getWorkbench().getDecoratorManager().setEnabled(TmcdbObjectIDLabelDecorator.ID, true);
			configurer.getWorkbench().getDecoratorManager().setEnabled(ComponentImplLangLabelDecorator.ID, true);
		} catch (CoreException e) {
			e.printStackTrace();
		}
        configurer.setSaveAndRestore( true );

    }
}
