/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.rcp;

import java.util.logging.LogManager;
import java.util.logging.Logger;

import org.apache.commons.logging.LogFactory;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

import alma.acs.tmcdb.translator.TmcdbObject;
import alma.obops.logging.StdOutConsoleHandler;
import alma.obops.tmcdbgui.TmcdbGui;

/**
 * This class controls all aspects of the application's execution
 */
public class Application implements IApplication {

    /** 
     * @see org.eclipse.equinox.app.IApplication#start(org.eclipse.equinox.app.IApplicationContext)
     */
    public Object start( IApplicationContext context ) {

    	loggingConfiguration("/alma/obops/tmcdbgui/rcp/tmcdb.logging.properties");
    	TmcdbObject.setUseContentEqualsAndHashCodeDefault(true);
        Display display = PlatformUI.createDisplay();
        try {
            int returnCode = PlatformUI
                    .createAndRunWorkbench( display,
                                            new ApplicationWorkbenchAdvisor() );
            if( returnCode == PlatformUI.RETURN_RESTART ) {
                return IApplication.EXIT_RESTART;
            }
        }
        catch(Exception th) {
        	Logger logger = TmcdbGui.getLogger();
        	logger.warning("Unexpected exception caught: " + th);
        	th.printStackTrace();
        }
        finally {
            display.dispose();
        }
        return IApplication.EXIT_OK;
    }

    /** 
     * @see org.eclipse.equinox.app.IApplication#stop()
     */
    public void stop() {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        if( workbench == null )
            return;
        final Display display = workbench.getDisplay();
        display.syncExec( new Runnable() {
            public void run() {
                if( !display.isDisposed() )
                    workbench.close();
            }
        } );
    }

	private void loggingConfiguration(String configResourceLocation) {
		try {
			// Let C3P0 use the JDK 1.4 logger
			System.setProperty("com.mchange.v2.log.MLog", "com.mchange.v2.log.jdk14logging.Jdk14MLog");

			// Commons-logging also uses the JDK 1.4 logger
			LogFactory.getFactory().setAttribute("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.Jdk14Logger");

			// If specified, read the JDK logging configuration from the given path
			if( configResourceLocation != null ) {
				LogManager.getLogManager().readConfiguration(Application.class.getResourceAsStream(configResourceLocation));
			}

			Logger rootLogger = Logger.getLogger("dummyName");
			while(rootLogger.getParent() != null) {
				rootLogger = rootLogger.getParent();
			}
			rootLogger.addHandler(new StdOutConsoleHandler());
		} catch (Exception e) {
			System.err.println("Exception while setting up the logging configuration, will use the default one");
		}
	}
}
